<?php
// Création de users

// On appelle la base de données et le header
require ('includes/dbconn.php');
include('includes/header.php');

// Initialisation des variables et du message flash
$message = '';
$message_type = ''; // 'success' ou 'danger'

// Vérification si le formulaire a été soumis
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login = htmlspecialchars(trim($_POST["login"]));
    $password = $_POST["mdp"];
    $confirm_password = $_POST["confir-mdp"];

    // Validation des données
    if (empty($login) || empty($password)) {
        $message = "Tous les champs sont obligatoires.";
        $message_type = "danger";
    } elseif ($password !== $confirm_password) {
        $message = "Les mots de passe ne correspondent pas.";
        $message_type = "danger";
    } elseif (strlen($password) < 8) {
        $message = "Le mot de passe doit contenir au moins 8 caractères.";
        $message_type = "danger";
    } else {
        // Vérification si l'utilisateur existe déjà
        $check_sql = "SELECT id FROM users WHERE login = ?";
        $stmt = mysqli_prepare($conn, $check_sql);
        mysqli_stmt_bind_param($stmt, "s", $login);
        mysqli_stmt_execute($stmt);
        mysqli_stmt_store_result($stmt);
        
        if (mysqli_stmt_num_rows($stmt) > 0) {
            $message = "Ce nom d'utilisateur est déjà pris.";
            $message_type = "danger";
        } else {
            // Hashage du mot de passe
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            
            // Création de la requête SQL préparée pour éviter les injections SQL
            $sql = "INSERT INTO users (login, password) VALUES (?, ?)";
            $stmt = mysqli_prepare($conn, $sql);
            mysqli_stmt_bind_param($stmt, "ss", $login, $hashed_password);
            
            // Exécution de la requête
            if (mysqli_stmt_execute($stmt)) {
                $message = "L'utilisateur a été ajouté avec succès.";
                $message_type = "success";
                
                // Réinitialisation des champs du formulaire
                $login = '';
            } else {
                $message = "Erreur lors de l'ajout de l'utilisateur: " . mysqli_error($conn);
                $message_type = "danger";
            }
        }
        mysqli_stmt_close($stmt);
    }
}
?>

<!-- Affichage du message flash -->
<?php if (!empty($message)): ?>
    <div class="alert alert-<?php echo $message_type; ?> alert-dismissible fade show" role="alert">
        <?php echo $message; ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<!-- Formulaire de création d'utilisateur -->
<form method="POST" action="">
    <div class="mb-3 col-5">
        <label class="form-label col-5">Nom d'utilisateur</label>
        <input type="text" class="form-control" name="login" value="<?php echo isset($login) ? htmlspecialchars($login) : ''; ?>" required>
    </div>
    <div class="mb-3 col-5">
        <label class="form-label">Mot de passe</label>
        <input type="password" class="form-control" name="mdp" required>
    </div>
    <div class="mb-3 col-5">
        <label class="form-label">Confirmation mot de passe</label>
        <input type="password" class="form-control" name="confir-mdp" required>
    </div>
    
    <button type="submit" class="btn btn-primary">Ajouter</button>
</form>

<?php
// Fermer la connexion à la base de données
mysqli_close($conn);
?>