<?php
ob_start();
session_start();
$userprofil = $_SESSION['user'];
if ($userprofil) {
    include('includes/header.php');
    require "includes/dbconn.php";
} else {
    header("Location: login.php");
    exit();
}

$alert = ""; // Message à afficher dans SweetAlert

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nom_classe = mysqli_real_escape_string($conn, $_POST['nom_classe']);
    $niveau_id = mysqli_real_escape_string($conn, $_POST['niveau_id']);

    $query = "INSERT INTO classes (nom, niveau_id) VALUES ('$nom_classe', '$niveau_id')";
    if (mysqli_query($conn, $query)) {
        $alert = "success";
    } else {
        $alert = "error";
    }
}

// Récupération des niveaux
$niveaux = mysqli_query($conn, "SELECT * FROM niveaux");
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter une classe</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600&display=swap" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        :root {
            --primary: #2B7A78;       /* Dark teal */
            --primary-light: #3AAFA9;  /* Medium teal */
            --primary-lighter: #DEF2F1; /* Light teal */
            --secondary: #17252A;      /* Dark blue */
            --accent: #FEFFFF;         /* White */
            --success: #28a745;
            --danger: #dc3545;
            --warning: #fd7e14;
        }
        
        body {
            background-color: #f8fafc;
            font-family: 'Poppins', sans-serif;
        }
        
        .form-container {
            max-width: 600px;
            margin: 40px auto;
            background: white;
            padding: 40px;
            border-radius: 12px;
            box-shadow: 0 8px 24px rgba(43, 122, 120, 0.1);
            border-left: 4px solid var(--primary);
        }
        
        .page-title {
            color: var(--secondary);
            font-weight: 600;
            text-align: center;
            margin-bottom: 30px;
            position: relative;
            padding-bottom: 15px;
        }
        
        .page-title:after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 3px;
            background: var(--primary-light);
        }
        
        label {
            font-weight: 500;
            color: var(--secondary);
            margin-bottom: 8px;
            display: block;
        }
        
        .form-control, .form-select {
            height: 48px;
            border-radius: 8px;
            border: 1px solid #e2e8f0;
            padding: 10px 15px;
            transition: all 0.3s;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-light);
            box-shadow: 0 0 0 0.25rem rgba(58, 175, 169, 0.15);
        }
        
        .btn-primary {
            background-color: var(--primary);
            border: none;
            padding: 12px 24px;
            font-weight: 500;
            border-radius: 8px;
            transition: all 0.3s;
        }
        
        .btn-primary:hover {
            background-color: var(--primary-light);
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(58, 175, 169, 0.2);
        }
        
        .btn-outline-secondary {
            border-color: var(--primary);
            color: var(--primary);
        }
        
        .btn-outline-secondary:hover {
            background-color: var(--primary);
            color: white;
        }
        
        .required-field::after {
            content: " *";
            color: var(--danger);
        }
        
        .form-icon {
            color: var(--primary);
            margin-right: 10px;
            width: 20px;
            text-align: center;
        }
        
        .form-group {
            margin-bottom: 25px;
            position: relative;
        }
        
        .form-group:after {
            content: '';
            position: absolute;
            bottom: -10px;
            left: 0;
            width: 100%;
            height: 1px;
            background: linear-gradient(90deg, transparent, var(--primary-lighter), transparent);
        }
        
        .action-buttons {
            margin-top: 40px;
        }
    </style>
</head>
<body>
<div class="container py-5">
    <div class="form-container">
        <h2 class="page-title">
            <i class="fas fa-chalkboard-teacher form-icon"></i>Ajouter une classe
        </h2>
        
        <form method="POST" novalidate>
            <div class="form-group">
                <label for="nom_classe" class="required-field">
                    <i class="fas fa-tag form-icon"></i>Nom de la classe
                </label>
                <input type="text" class="form-control" id="nom_classe" name="nom_classe" 
                       placeholder="Ex: Auxiliaire en pharmacie" required>
            </div>
            
            <div class="form-group">
                <label for="niveau_id" class="required-field">
                    <i class="fas fa-layer-group form-icon"></i>Niveau associé
                </label>
                <select class="form-select" id="niveau_id" name="niveau_id" required>
                    <option value="" selected disabled>-- Sélectionnez un niveau --</option>
                    <?php while($niveau = mysqli_fetch_assoc($niveaux)): ?>
                        <option value="<?= $niveau['id'] ?>"><?= htmlspecialchars($niveau['nom_niveau']) ?></option>
                    <?php endwhile; ?>
                </select>
            </div>
            
            <div class="action-buttons d-flex justify-content-end gap-3">
                <a href="listClasse.php" class="btn btn-outline-secondary">
                    <i class="fas fa-arrow-left me-2"></i> Annuler
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save me-2"></i> Enregistrer
                </button>
            </div>
        </form>
    </div>
</div>

<?php if ($alert == "success"): ?>
<script>
    Swal.fire({
        icon: 'success',
        title: 'Succès',
        text: 'Classe ajoutée avec succès !',
        confirmButtonColor: 'var(--primary)',
        backdrop: `
            rgba(43, 122, 120, 0.4)
           
            left top
            no-repeat
        `
    }).then(() => {
        window.location.href = 'listClasse.php';
    });
</script>
<?php elseif ($alert == "error"): ?>
<script>
    Swal.fire({
        icon: 'error',
        title: 'Erreur',
        text: 'Une erreur est survenue lors de l\'ajout.',
        confirmButtonColor: 'var(--primary)'
    });
</script>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>