<?php 
session_start();
$userprofil = $_SESSION['user'];
if (!$userprofil) {
    header("Location: login.php");
    exit();
}
include('includes/header.php');
require_once "includes/dbconn.php";

// Initialiser les variables
$success = false;
$error = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nom = trim($_POST['nom']);
    $prenom = trim($_POST['prenom']);
    $email = trim($_POST['email']);
    $telephone = trim($_POST['telephone']);
    $matiere = trim($_POST['matiere']);
    $grade = trim($_POST['grade']);

    if ($nom && $prenom && $email && $matiere && $grade) {
        $check = $conn->prepare("SELECT id FROM enseignants WHERE email = ?");
        $check->bind_param("s", $email);
        $check->execute();
        $check->store_result();

        if ($check->num_rows > 0) {
            $error = "Cet email est déjà utilisé par un autre enseignant.";
        } else {
            $stmt = $conn->prepare("INSERT INTO enseignants (nom, prenom, email, telephone, matiere, grade) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->bind_param("ssssss", $nom, $prenom, $email, $telephone, $matiere, $grade);
            if ($stmt->execute()) {
                $success = true;
            } else {
                $error = "Erreur lors de l'enregistrement.";
            }
        }
    } else {
        $error = "Veuillez remplir tous les champs obligatoires.";
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Ajout d'un enseignant</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600&display=swap" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <style>
    :root {
      --primary: #2B7A78;
      --primary-light: #3AAFA9;
      --primary-lighter: #DEF2F1;
      --secondary: #17252A;
      --accent: #FEFFFF;
    }
    body, html {
      height: 100%;
      margin: 0;
      font-family: 'Montserrat', sans-serif;
      background-color: #f8fafc;
      overflow: hidden;
    }
    .main-container {
      height: 100vh;
      display: flex;
      flex-direction: column;
    }
    .form-wrapper {
      flex: 1;
      max-width: 800px;
      width: 100%;
      margin: 0 auto;
      padding: 20px;
      background-color: var(--accent);
      border-radius: 12px;
      box-shadow: 0 6px 15px rgba(0,0,0,0.05);
      border-left: 4px solid var(--primary);
      overflow-y: auto;
      max-height: calc(100vh - 40px);
    }
    .form-title {
      font-weight: 600;
      color: var(--secondary);
      margin-bottom: 15px;
      position: relative;
      padding-bottom: 8px;
      font-size: 1.25rem;
    }
    .form-title:after {
      content: '';
      position: absolute;
      bottom: 0;
      left: 0;
      width: 40px;
      height: 3px;
      background: var(--primary-light);
    }
    .form-label {
      font-weight: 500;
      font-size: 0.9rem;
      color: var(--secondary);
      margin-bottom: 6px;
    }
    .form-control, .form-select {
      font-size: 0.9rem;
      padding: 7px 12px;
      border: 1px solid #e2e8f0;
      border-radius: 6px;
      height: 38px;
    }
    .form-control:focus, .form-select:focus {
      border-color: var(--primary-light);
      box-shadow: 0 0 0 0.2rem rgba(43, 122, 120, 0.15);
    }
    .btn-submit {
      padding: 8px 20px;
      font-size: 0.9rem;
      font-weight: 500;
      background-color: var(--primary);
      border: none;
      border-radius: 6px;
      transition: all 0.2s;
    }
    .btn-submit:hover {
      background-color: var(--primary-light);
    }
    .title-icon {
      color: var(--primary);
      margin-right: 8px;
    }
    .input-group-text {
      background-color: var(--primary-lighter);
      color: var(--primary);
      border: 1px solid #e2e8f0;
      padding: 0 12px;
      font-size: 0.9rem;
    }
    .form-section {
      margin-bottom: 15px;
      padding-bottom: 10px;
      border-bottom: 1px dashed #e2e8f0;
    }
    .form-section h6 {
      font-size: 0.95rem;
    }
    .compact-row {
      margin-bottom: 10px;
    }
  </style>
</head>
<body>
<div class="main-container">
  <div class="form-wrapper">
    <h5 class="form-title"><i class="bi bi-person-plus-fill title-icon"></i>Ajouter un nouvel enseignant</h5>
    <form method="POST">

      <div class="form-section">
        <h6 class="mb-2 text-muted"><i class="bi bi-person-lines-fill me-2"></i>Informations personnelles</h6>
        <div class="row compact-row">
          <div class="col-md-6 mb-2">
            <label class="form-label">Nom</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-person"></i></span>
              <input type="text" name="nom" class="form-control" required>
            </div>
          </div>
          <div class="col-md-6 mb-2">
            <label class="form-label">Prénom</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-person"></i></span>
              <input type="text" name="prenom" class="form-control" required>
            </div>
          </div>
        </div>
      </div>

      <div class="form-section">
        <h6 class="mb-2 text-muted"><i class="bi bi-envelope-at-fill me-2"></i>Coordonnées</h6>
        <div class="row compact-row">
          <div class="col-md-6 mb-2">
            <label class="form-label">Email</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-envelope"></i></span>
              <input type="email" name="email" class="form-control" required>
            </div>
          </div>
          <div class="col-md-6 mb-2">
            <label class="form-label">Téléphone</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-telephone"></i></span>
              <input type="tel" name="telephone" class="form-control">
            </div>
          </div>
        </div>
      </div>

      <div class="form-section">
        <h6 class="mb-2 text-muted"><i class="bi bi-book-half me-2"></i>Informations professionnelles</h6>
        <div class="row compact-row">
          <div class="col-md-6 mb-2">
            <label class="form-label">Matière</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-journal-bookmark"></i></span>
              <input type="text" name="matiere" class="form-control" required>
            </div>
          </div>
          <div class="col-md-6 mb-2">
            <label class="form-label">Grade</label>
            <div class="input-group">
              <span class="input-group-text"><i class="bi bi-award"></i></span>
              <select name="grade" class="form-select" required>
                <option value="">-- Sélectionner --</option>
                <option value="Maître assistant">Maître assistant</option>
                <option value="Maître de conférences">Maître de conférences</option>
                <option value="Professeur">Professeur</option>
              </select>
            </div>
          </div>
        </div>
      </div>

      <div class="d-flex justify-content-between mt-3">
        <a href="list_prof.php" class="btn btn-outline-secondary btn-sm">
          <i class="bi bi-arrow-left"></i> Retour
        </a>
        <button type="submit" class="btn btn-submit text-white">
          <i class="bi bi-check-circle-fill"></i> Enregistrer
        </button>
      </div>
    </form>
  </div>
</div>

<?php if ($success): ?>
<script>
  Swal.fire({
    icon: 'success',
    title: 'Succès',
    text: 'Enseignant ajouté avec succès.',
    confirmButtonColor: '#2B7A78'
  }).then(() => window.location.href = "list_prof.php");
</script>
<?php elseif ($error): ?>
<script>
  Swal.fire({
    icon: 'error',
    title: 'Erreur',
    text: <?= json_encode($error) ?>,
    confirmButtonColor: '#2B7A78'
  });
</script>
<?php endif; ?>

</body>
</html>