<?php 
session_start();
$userprofil = $_SESSION['user'];
if ($userprofil == true) {
    include('includes/header.php');
    require_once "includes/dbconn.php";
} else {
    header("Location: login.php");
    exit();
}

// Récupérer toutes les classes pour le select
$classes = [];
$result = $conn->query("SELECT id, nom FROM classes ORDER BY nom");
if ($result) {
    $classes = $result->fetch_all(MYSQLI_ASSOC);
}

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nomModule = trim($_POST['nomModule']);
    $classeId = intval($_POST['classe']);
    $coefficient = intval($_POST['coefficient']);

    if ($nomModule && $classeId > 0 && $coefficient > 0) {
        $stmt = $conn->prepare("INSERT INTO modules (nom, coefficient, classe_id) VALUES (?, ?, ?)");
        $stmt->bind_param("sii", $nomModule, $coefficient, $classeId);

        if ($stmt->execute()) {
            $message = "<div class='alert alert-success'>Module <strong>" . htmlspecialchars($nomModule) . "</strong> ajouté avec succès.</div>";
        } else {
            $message = "<div class='alert alert-danger'>Erreur : " . $conn->error . "</div>";
        }
        $stmt->close();
    } else {
        $message = "<div class='alert alert-danger'>Veuillez remplir tous les champs correctement.</div>";
    }
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Ajouter un module</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body {
            background: #f3f3f3;
            font-family: 'Segoe UI', sans-serif;
        }
        .form-container {
            max-width: 550px;
            margin: 80px auto;
            background: #fff;
            padding: 35px;
            border-radius: 15px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            border-top: 6px solid #800000;
        }
        h4 {
            color: #800000;
        }
        .btn-bordeaux {
            background-color: #800000;
            color: #fff;
        }
        .btn-bordeaux:hover {
            background-color: #a00000;
        }
    </style>
</head>
<body>

<div class="container">
    <div class="form-container">
        <h4 class="mb-4 text-center">Ajouter un module</h4>

        <?php if (isset($message)) echo $message; ?>

        <form method="POST" novalidate>
            <div class="mb-3">
                <label for="nomModule" class="form-label">Nom du module</label>
                <input type="text" id="nomModule" name="nomModule" class="form-control" placeholder="Ex: Mathématiques" required>
            </div>

            <div class="mb-3">
                <label for="classe" class="form-label">Classe concernée</label>
                <select id="classe" name="classe" class="form-select" required>
                    <option value="">-- Sélectionnez une classe --</option>
                    <?php foreach ($classes as $classe): ?>
                        <option value="<?= $classe['id'] ?>"><?= htmlspecialchars($classe['nom']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="mb-3">
                <label for="coefficient" class="form-label">Coefficient</label>
                <input type="number" id="coefficient" name="coefficient" class="form-control" min="1" placeholder="Ex: 4" required>
            </div>

            <div class="d-grid">
                <button type="submit" class="btn btn-bordeaux">Enregistrer le module</button>
            </div>
        </form>
    </div>
</div>

</body>
</html>
