<?php
require 'includes/dbconn.php';
include 'includes/header.php';

$message = '';
$success = false;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $libelle = trim($_POST['libelle']);
    $montant = floatval($_POST['montant']);
    $date_operation = $_POST['date_operation'];

    if (!empty($libelle) && $montant > 0 && !empty($date_operation)) {
        $stmt = $conn->prepare("INSERT INTO caisse (type, libelle, montant, date_operation) VALUES ('depense', ?, ?, ?)");
        $stmt->bind_param("sds", $libelle, $montant, $date_operation);

        if ($stmt->execute()) {
            $success = true;
            $message = "Dépense enregistrée avec succès";
            // Réinitialiser les valeurs du formulaire après succès
            $_POST = array();
        } else {
            $message = "Erreur lors de l'enregistrement";
        }
        $stmt->close();
    } else {
        $message = "Veuillez remplir tous les champs correctement";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Enregistrer une dépense</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary: #4361ee;  /* Bleu moderne */
            --primary-light: #4895ef;
            --primary-dark: #3a0ca3;
            --success: #4cc9f0;
            --light-bg: #f8f9fa;
        }
        
        body {
            background-color: var(--light-bg);
            font-family: 'Segoe UI', system-ui, sans-serif;
        }
        
        .form-container {
            max-width: 600px;
            margin: 2rem auto;
            padding: 2rem;
            background: white;
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.08);
        }
        
        .form-title {
            color: var(--primary);
            font-weight: 600;
            margin-bottom: 1.5rem;
            text-align: center;
        }
        
        .form-icon {
            font-size: 1.5rem;
            margin-right: 0.5rem;
            color: var(--primary);
        }
        
        .btn-submit {
            background-color: var(--primary);
            border: none;
            padding: 0.5rem 1.5rem;
            transition: all 0.3s ease;
        }
        
        .btn-submit:hover {
            background-color: var(--primary-dark);
            transform: translateY(-2px);
        }
        
        .form-control, .form-select {
            border-radius: 8px;
            padding: 0.75rem 1rem;
            border: 1px solid #e0e0e0;
        }
        
        .form-control:focus {
            border-color: var(--primary-light);
            box-shadow: 0 0 0 3px rgba(67, 97, 238, 0.15);
        }
        
        .input-group-text {
            background-color: var(--primary);
            color: white;
            border: none;
            border-radius: 8px 0 0 8px;
        }
        
        .floating-alert {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1000;
            animation: slideIn 0.3s ease-out;
        }
        
        @keyframes slideIn {
            from { transform: translateX(100%); opacity: 0; }
            to { transform: translateX(0); opacity: 1; }
        }
        
        .simple-input {
            border: none;
            border-bottom: 2px solid #e0e0e0;
            border-radius: 0;
            padding-left: 0;
            padding-right: 0;
            background: transparent;
        }
        
        .simple-input:focus {
            box-shadow: none;
            border-bottom-color: var(--primary);
        }
    </style>
</head>
<body>
    <div class="container py-4">
        <div class="form-container">
            <h2 class="form-title">
                <i class="bi bi-wallet2 form-icon"></i>
                Nouvelle Dépense
            </h2>
            
            <form method="POST" id="depenseForm">
                <div class="mb-4">
                    <label for="libelle" class="form-label fw-medium">Description</label>
                    <input type="text" name="libelle" class="form-control simple-input" 
                           placeholder="Achat de matériel" 
                           value="<?= htmlspecialchars($_POST['libelle'] ?? '') ?>" required>
                </div>
                
                <div class="mb-4">
                    <label for="montant" class="form-label fw-medium">Montant</label>
                    <div class="input-group">
                        <span class="input-group-text">FCFA</span>
                        <input type="number" name="montant" class="form-control" 
                               step="0.01" min="0.01" placeholder="5000.00" 
                               value="<?= htmlspecialchars($_POST['montant'] ?? '') ?>" required>
                    </div>
                </div>
                
                <div class="mb-4">
                    <label for="date_operation" class="form-label fw-medium">Date</label>
                    <input type="date" name="date_operation" class="form-control" 
                           value="<?= htmlspecialchars($_POST['date_operation'] ?? date('Y-m-d')) ?>" required>
                </div>
                
                <div class="d-grid gap-2 mt-4">
                    <button type="submit" class="btn btn-submit btn-lg text-white">
                        <i class="bi bi-check-circle"></i> Valider
                    </button>
                </div>
            </form>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    
    <script>
    document.addEventListener('DOMContentLoaded', function() {
        <?php if (!empty($message)): ?>
        // Notification flottante
        const alertDiv = document.createElement('div');
        alertDiv.className = 'alert alert-<?= $success ? 'success' : 'danger' ?> floating-alert alert-dismissible fade show';
        alertDiv.innerHTML = `
            <i class="bi bi-<?= $success ? 'check-circle-fill' : 'exclamation-triangle-fill' ?> me-2"></i>
            <?= $message ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        `;
        document.body.appendChild(alertDiv);
        
        // Disparaît après 5 secondes
        setTimeout(() => {
            alertDiv.classList.remove('show');
            setTimeout(() => alertDiv.remove(), 300);
        }, 5000);
        <?php endif; ?>
        
        // Confirmation avant soumission
        document.getElementById('depenseForm').addEventListener('submit', function(e) {
            const btn = this.querySelector('button[type="submit"]');
            btn.innerHTML = '<span class="spinner-border spinner-border-sm"></span> En cours...';
            btn.disabled = true;
        });
    });
    </script>
</body>
</html>

<?php include 'includes/footer.php'; ?>