<?php
session_start();
// include('includes/auth.php'); // Sécurité
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Dashboard - Gestion Immobilière</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!-- Bootstrap -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <!-- Icons -->
  <script src="https://unpkg.com/lucide@latest"></script>
  <!-- Custom CSS -->
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f5f7fa;
    }
    .sidebar {
      height: 100vh;
      background: #0d6efd;
      color: white;
      padding: 1rem;
      position: fixed;
      width: 250px;
      transition: all 0.3s;
    }
    .sidebar a {
      color: white;
      text-decoration: none;
      display: block;
      margin: 15px 0;
    }
    .sidebar .active {
      font-weight: bold;
      background: rgba(255,255,255,0.2);
      border-radius: 8px;
      padding: 5px 10px;
    }
    .content {
      margin-left: 250px;
      padding: 2rem;
    }
    .sidebar-collapsed {
      width: 70px !important;
    }
    .sidebar-collapsed .nav-text {
      display: none;
    }
    .sidebar-collapsed .logo-text {
      display: none;
    }
    .toggle-btn {
      position: absolute;
      top: 10px;
      left: 260px;
      background: transparent;
      border: none;
    }
    @media(max-width: 768px) {
      .sidebar {
        left: -250px;
        position: absolute;
      }
      .sidebar.show {
        left: 0;
      }
      .content {
        margin-left: 0;
      }
      .toggle-btn {
        left: 10px;
      }
    }
  </style>
</head>
<body>

<!-- Sidebar -->
<div class="sidebar" id="sidebar">
  <h5 class="logo-text">🏠 Immobilier</h5>
  <a href="#" class="active"><i data-lucide="layout-dashboard"></i> <span class="nav-text">Dashboard</span></a>
  <a href="#"><i data-lucide="building-2"></i> <span class="nav-text">Biens</span></a>
  <a href="#"><i data-lucide="users"></i> <span class="nav-text">Locataires</span></a>
  <a href="#"><i data-lucide="wallet"></i> <span class="nav-text">Loyers</span></a>
  <a href="#"><i data-lucide="file-text"></i> <span class="nav-text">Contrats</span></a>
  <a href="#"><i data-lucide="settings"></i> <span class="nav-text">Paramètres</span></a>
</div>

<!-- Toggle Button -->
<button class="toggle-btn" id="toggleBtn">
  <i data-lucide="menu"></i>
</button>

<!-- Main Content -->
<div class="content">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h3>Dashboard</h3>
    <div class="d-flex align-items-center">
      <i data-lucide="bell" class="me-3"></i>
      <img src="assets/images/user.png" alt="User" class="rounded-circle" width="40">
    </div>
  </div>

  <!-- Cards -->
  <div class="row">
    <div class="col-md-4 mb-3">
      <div class="card shadow-sm">
        <div class="card-body">
          <h5>Biens</h5>
          <h2>18</h2>
        </div>
      </div>
    </div>
    <div class="col-md-4 mb-3">
      <div class="card shadow-sm">
        <div class="card-body">
          <h5>Locataires</h5>
          <h2>25</h2>
        </div>
      </div>
    </div>
    <div class="col-md-4 mb-3">
      <div class="card shadow-sm">
        <div class="card-body">
          <h5>Revenus ce mois</h5>
          <h2>1 250 000 FCFA</h2>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Scripts -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
  lucide.createIcons();

  const toggleBtn = document.getElementById('toggleBtn');
  const sidebar = document.getElementById('sidebar');

  toggleBtn.addEventListener('click', () => {
    if (window.innerWidth < 768) {
      sidebar.classList.toggle('show');
    } else {
      sidebar.classList.toggle('sidebar-collapsed');
    }
  });
</script>
</body>
</html>
