<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Attestation de Fin de Formation</title>
    <style>
        @page {
            size: A4;
            margin: 0;
        }
        body {
            font-family: 'Times New Roman', serif;
            background-color: #fff;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .certificate-container {
            width: 210mm;
            height: 297mm;
            margin: 0 auto;
            position: relative;
            background-color: #fff;
            overflow: hidden;
        }
        .border-design {
            position: absolute;
            width: calc(100% - 40px);
            height: calc(100% - 40px);
            border: 15px double #800020;
            top: 20px;
            left: 20px;
            z-index: 1;
        }
        .corner {
            position: absolute;
            width: 80px;
            height: 80px;
            border-color: #d4af37;
            border-style: solid;
            z-index: 2;
        }
        .corner-top-left {
            top: 20px;
            left: 20px;
            border-width: 8px 0 0 8px;
        }
        .corner-top-right {
            top: 20px;
            right: 20px;
            border-width: 8px 8px 0 0;
        }
        .corner-bottom-left {
            bottom: 20px;
            left: 20px;
            border-width: 0 0 8px 8px;
        }
        .corner-bottom-right {
            bottom: 20px;
            right: 20px;
            border-width: 0 8px 8px 0;
        }
        .watermark {
            position: absolute;
            opacity: 0.1;
            font-size: 120px;
            color: #800020;
            transform: rotate(-45deg);
            z-index: 0;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%) rotate(-45deg);
            font-weight: bold;
            letter-spacing: 10px;
        }
        .content {
            position: relative;
            z-index: 3;
            padding: 60px;
            height: 100%;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-align: center;
        }
        .header {
            margin-bottom: 40px;
        }
        .header img {
            height: 100px;
        }
        .header h1 {
            color: #800020;
            font-size: 28px;
            margin: 20px 0 10px;
            text-transform: uppercase;
            letter-spacing: 2px;
        }
        .header p {
            font-style: italic;
            margin: 5px 0;
        }
        .main-text {
            margin: 30px 0;
            line-height: 1.8;
            font-size: 18px;
        }
        .signature-area {
            margin-top: 60px;
            width: 100%;
            display: flex;
            justify-content: space-around;
        }
        .signature {
            display: inline-block;
            margin-top: 20px;
        }
        .signature-line {
            width: 200px;
            border-top: 1px solid #333;
            margin: 0 auto;
            padding-top: 5px;
        }
        .stamp {
            position: absolute;
            right: 100px;
            bottom: 100px;
            opacity: 0.8;
            z-index: 4;
        }
        .footer {
            margin-top: 40px;
            font-size: 14px;
            color: #666;
        }
        .seal {
            position: absolute;
            bottom: 80px;
            left: 50%;
            transform: translateX(-50%);
            width: 80px;
            height: 80px;
            background-color: #d4af37;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #800020;
            font-weight: bold;
            font-size: 12px;
            text-align: center;
            line-height: 1.2;
            border: 2px solid #800020;
        }
    </style>
</head>
<body>
    <div class="certificate-container">
        <!-- Bordure décorative -->
        <div class="border-design"></div>
        
        <!-- Coins décoratifs -->
        <div class="corner corner-top-left"></div>
        <div class="corner corner-top-right"></div>
        <div class="corner corner-bottom-left"></div>
        <div class="corner corner-bottom-right"></div>
        
        <!-- Filigrane -->
        <div class="watermark">E3S</div>
        
        <!-- Contenu principal -->
        <div class="content">
            <div class="header">
                <img src="assetss/logo.jpeg" alt="Logo E3S">
                <h1>Attestation de Fin de Formation</h1>
                <p>ECOLE SINE SALOUM SANTE</p>
                <p>Kaolack, Leona Lot 167 - Tél: +221 33 941 00 08</p>
            </div>
            
            <div class="main-text">
                <p>Le Directeur de l'École Sine Saloum Santé certifie que :</p>
                <p style="font-size: 22px; font-weight: bold; margin: 20px 0; color: #800020;">
                    [NOM ET PRÉNOM DE L'ÉTUDIANT(E)]
                </p>
                <p>a suivi avec assiduité et a validé avec succès la formation en :</p>
                <p style="font-size: 20px; font-weight: bold; margin: 15px 0; color: #d4af37;">
                    [NOM DE LA FORMATION]
                </p>
                <p>d'une durée de [NOMBRE] heures, du [DATE DE DÉBUT] au [DATE DE FIN].</p>
                <p>La présente attestation lui est délivrée pour servir et valoir ce que de droit.</p>
            </div>
            
            <div class="signature-area">
                <div class="signature">
                    <p>Fait à Kaolack, le [DATE]</p>
                    <div class="signature-line"></div>
                    <p>Le Directeur Pédagogique</p>
                </div>
                
                <div class="signature">
                    <p>Cachet et signature</p>
                    <div class="signature-line"></div>
                    <p>Le Directeur Général</p>
                </div>
            </div>
            
            <div class="seal">
                SCEAU<br>OFFICIEL<br>E3S
            </div>
            
            <div class="footer">
                <p>Attestation délivrée en un seul exemplaire - N° d'enregistrement: [NUMÉRO]</p>
            </div>
        </div>
        
        <!-- Cachet (optionnel) -->
        <div class="stamp">
            <!-- Insérer ici une image de cachet si disponible -->
        </div>
    </div>
</body>
</html>