<?php
session_start();
$userprofil = $_SESSION['user'] ?? null;
if (!$userprofil) {
    header("Location: login.php");
    exit();
}
include('includes/header.php');
require_once "includes/dbconn.php";

$etudiant = null;
$autorisation_data = null;

if (isset($_POST['chercher'])) {
    $matricule = mysqli_real_escape_string($conn, $_POST['matricule']);
    $query = "SELECT e.*, c.nom AS classe
              FROM etudiants e
              JOIN classes c ON e.classe_id = c.id
              WHERE e.matricule = '$matricule'";
    $result = mysqli_query($conn, $query);
    $etudiant = mysqli_fetch_assoc($result);
}

if (isset($_POST['enregistrer'])) {
    $etudiant_id = $_POST['etudiant_id'];
    $classe_id = $_POST['classe_id'];
    $date_debut = $_POST['date_debut'];
    $date_fin = $_POST['date_fin'];
    $motif = mysqli_real_escape_string($conn, $_POST['motif']);

    $insert = "INSERT INTO autorisations_absence (etudiant_id, classe_id, date_debut, date_fin, motif)
               VALUES (?, ?, ?, ?, ?)";
    $stmt2 = $conn->prepare($insert);
    $stmt2->bind_param("iisss", $etudiant_id, $classe_id, $date_debut, $date_fin, $motif);
    $stmt2->execute();

    $autorisation_data = [
        'nom' => $_POST['nom'],
        'prenom' => $_POST['prenom'],
        'classe' => $_POST['classe'],
        'date_debut' => $date_debut,
        'date_fin' => $date_fin,
        'motif' => $motif
    ];
}
?>

<div class="container mt-4 p-4 border rounded shadow bg-white w-75" style="min-height: 600px; display: flex; flex-direction: column; justify-content: space-between;">
    <div>
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h5 class="fw-bold text-center mb-0">Autorisation d'absence étudiant</h5>
            <!-- Bouton vert-bleu vers aperçu_autorisation.php -->
            <a href="aperçu_autorisation.php" class="btn text-white" style="background-color: #2a6f6b; border: 1px solid #1d4d4a;">
                <i class="fas fa-list me-1"></i> Voir les autorisations
            </a>
        </div>

        <form method="POST" class="mb-4">
            <div class="row g-3 align-items-end">
                <div class="col-md-8">
                    <label class="form-label fw-bold">Matricule de l'étudiant</label>
                    <input type="text" name="matricule" class="form-control" value="<?= htmlspecialchars($_POST['matricule'] ?? '') ?>" required>
                </div>
                <div class="col-md-4">
                    <button type="submit" name="chercher" class="btn text-white w-100" style="background-color: #3a7ca5;">Rechercher</button>
                </div>
            </div>
        </form>

        <?php if ($etudiant): ?>
            <form method="POST">
                <input type="hidden" name="etudiant_id" value="<?= $etudiant['id'] ?>">
                <input type="hidden" name="classe_id" value="<?= $etudiant['classe_id'] ?>">
                <input type="hidden" name="nom" value="<?= htmlspecialchars($etudiant['noms']) ?>">
                <input type="hidden" name="prenom" value="<?= htmlspecialchars($etudiant['prenom']) ?>">
                <input type="hidden" name="classe" value="<?= htmlspecialchars($etudiant['classe']) ?>">

                <div class="row g-3 mb-3">
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Nom</label>
                        <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['noms']) ?>" disabled>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Prénom</label>
                        <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['prenom']) ?>" disabled>
                    </div>
                    <div class="col-md-4">
                        <label class="form-label fw-bold">Classe</label>
                        <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['classe']) ?>" disabled>
                    </div>
                </div>

                <div class="row g-3 mb-3">
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Date début</label>
                        <input type="date" name="date_debut" class="form-control" required>
                    </div>
                    <div class="col-md-6">
                        <label class="form-label fw-bold">Date fin</label>
                        <input type="date" name="date_fin" class="form-control" required>
                    </div>
                </div>

                <div class="mb-3">
                    <label class="form-label fw-bold">Motif</label>
                    <textarea name="motif" class="form-control" rows="3" required></textarea>
                </div>

                <button type="submit" name="enregistrer" class="btn text-white w-100" style="background-color: #2a6f6b;">Enregistrer l'autorisation</button>
            </form>
        <?php endif; ?>
    </div>

    <?php if ($autorisation_data): ?>
        <div id="printSection" style="font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;">

            <!-- En-tête moderne -->
            <div class="d-flex align-items-center mb-4" style="border-bottom: 2px solid #2a6f6b; padding-bottom: 15px;">
                <img src="assetss/logo.jpeg" alt="Logo école" style="height: 80px; margin-right: 20px; filter: drop-shadow(2px 2px 4px rgba(0,0,0,0.1));">
                <div style="text-align: center; width: 100%;">
                    <h4 style="font-weight: 700; margin-bottom: 5px; color: #164e63;">MAIN IT-CENTER</h4>
                    <div style="color: #3a7ca5; font-size: 0.9rem;">Adresse : Kaolack, Leona</div>
                    <div style="color: #3a7ca5; font-size: 0.9rem;">Téléphone : +221 76 947 21 10</div>
                    <div style="color: #3a7ca5; font-size: 0.9rem;">Email : mainitcenter@gmail.com.com</div>
                </div>
            </div>

            <!-- Titre stylisé -->
            <div style="background: linear-gradient(to right, #2a6f6b, #3a7ca5); padding: 10px; border-radius: 5px; margin-bottom: 25px;">
                <h3 class="text-center text-white mb-0" style="letter-spacing: 1.5px; font-weight: 700; text-shadow: 1px 1px 3px rgba(0,0,0,0.2);">AUTORISATION D'ABSENCE</h3>
            </div>

            <!-- Carte d'information moderne -->
            <div style="background-color: #f0fdfa; border-radius: 10px; padding: 20px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); margin-bottom: 30px;">
                <div class="row">
                    <div class="col-md-6">
                        <div style="margin-bottom: 15px;">
                            <div style="font-weight: 600; color: #164e63; margin-bottom: 3px;">Nom</div>
                            <div style="font-size: 1.1rem; padding: 8px; background-color: white; border-radius: 5px; border-left: 4px solid #2a6f6b;">
                                <?= htmlspecialchars($autorisation_data['nom']) ?>
                            </div>
                        </div>
                        <div style="margin-bottom: 15px;">
                            <div style="font-weight: 600; color: #164e63; margin-bottom: 3px;">Prénom</div>
                            <div style="font-size: 1.1rem; padding: 8px; background-color: white; border-radius: 5px; border-left: 4px solid #2a6f6b;">
                                <?= htmlspecialchars($autorisation_data['prenom']) ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div style="margin-bottom: 15px;">
                            <div style="font-weight: 600; color: #164e63; margin-bottom: 3px;">Classe</div>
                            <div style="font-size: 1.1rem; padding: 8px; background-color: white; border-radius: 5px; border-left: 4px solid #2a6f6b;">
                                <?= htmlspecialchars($autorisation_data['classe']) ?>
                            </div>
                        </div>
                        <div style="margin-bottom: 15px;">
                            <div style="font-weight: 600; color: #164e63; margin-bottom: 3px;">Période</div>
                            <div style="font-size: 1.1rem; padding: 8px; background-color: white; border-radius: 5px; border-left: 4px solid #2a6f6b;">
                                Du <?= htmlspecialchars($autorisation_data['date_debut']) ?> au <?= htmlspecialchars($autorisation_data['date_fin']) ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div>
                    <div style="font-weight: 600; color: #164e63; margin-bottom: 3px;">Motif</div>
                    <div style="padding: 12px; background-color: white; border-radius: 5px; border-left: 4px solid #2a6f6b; min-height: 80px;">
                        <?= nl2br(htmlspecialchars($autorisation_data['motif'])) ?>
                    </div>
                </div>
            </div>

            <!-- Date et signatures modernes -->
            <div style="margin-top: 40px;">
                <div style="text-align: right; margin-bottom: 50px; color: #6b7280; font-style: italic;">
                    Fait à Kaolack, le <?= date('d/m/Y') ?>
                </div>
                
                <div style="display: flex; justify-content: space-between; margin-top: 60px;">
                    <div style="text-align: center; width: 45%;">
                        <div style="border-top: 2px dashed #2a6f6b; width: 70%; margin: 0 auto 10px; padding-top: 10px;"></div>
                        <div style="font-weight: 600; color: #164e63;">Signature de l'étudiant</div>
                    </div>
                    <div style="text-align: center; width: 45%;">
                        <div style="border-top: 2px dashed #2a6f6b; width: 70%; margin: 0 auto 10px; padding-top: 10px;"></div>
                        <div style="font-weight: 600; color: #164e63;">Signature du surveillant</div>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center my-4">
            <button id="btnImprimer" class="btn px-4 py-2 text-white" style="background-color: #3a7ca5; border: none; border-radius: 30px; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
                <i class="fas fa-print me-2"></i>Imprimer l'autorisation
            </button>
        </div>
    <?php endif; ?>
</div>

<!-- Bootstrap JS et Font Awesome -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">

<?php if ($autorisation_data): ?>
<script>
document.getElementById('btnImprimer').addEventListener('click', function() {
    const printContents = document.getElementById('printSection').innerHTML;

    const printWindow = window.open('', '', 'height=600,width=800');
    printWindow.document.write('<html><head><title>Impression Autorisation</title>');
    printWindow.document.write('<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">');
    printWindow.document.write('<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">');
    printWindow.document.write(`<style>
        @import url('https://fonts.googleapis.com/css2?family=Roboto:wght@300;400;500;700&display=swap');
        
        body { 
            margin: 30px; 
            font-family: 'Roboto', sans-serif;
            color: #333;
        }
        
        .header-section {
            border-bottom: 2px solid #2a6f6b; 
            padding-bottom: 15px;
            margin-bottom: 25px;
        }
        
        .title-section {
            background: linear-gradient(to right, #2a6f6b, #3a7ca5);
            padding: 10px;
            border-radius: 5px;
            margin-bottom: 25px;
        }
        
        .info-card {
            background-color: #f0fdfa;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            margin-bottom: 30px;
        }
        
        .info-label {
            font-weight: 600; 
            color: #164e63; 
            margin-bottom: 3px;
        }
        
        .info-value {
            font-size: 1.1rem;
            padding: 8px;
            background-color: white;
            border-radius: 5px;
            border-left: 4px solid #2a6f6b;
            margin-bottom: 15px;
        }
        
        .signature-line {
            border-top: 2px dashed #2a6f6b;
            width: 70%;
            margin: 0 auto 10px;
            padding-top: 10px;
        }
        
        .signature-label {
            font-weight: 600;
            color: #164e63;
        }
        
        @media print {
            body { 
                margin: 15px;
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none !important;
            }
        }
        </style>`);
    printWindow.document.write('</head><body>');
    printWindow.document.write(printContents);
    printWindow.document.write('</body></html>');
    
    printWindow.document.close();
    printWindow.focus();
    
    // Attendre que les styles soient chargés avant d'imprimer
    setTimeout(function() {
        printWindow.print();
        printWindow.close();
    }, 500);
});
</script>
<?php endif; ?>