<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Attribution Professeurs/Classes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #800020; /* Bordeaux */
            --secondary-color: #D4AF37; /* Or */
            --light-bg: #f8f5f5;
        }
        
        body {
            background-color: #f9f6f6;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .form-container {
            background-color: white;
            border-radius: 12px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
            padding: 30px;
            margin-top: 30px;
            border: 1px solid #e0d0d0;
        }
        
        .form-header {
            background: linear-gradient(135deg, var(--primary-color) 0%, #600000 100%);
            color: white;
            border-radius: 10px 10px 0 0;
            padding: 20px;
            margin: -30px -30px 30px -30px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-bottom: 3px solid var(--secondary-color);
        }
        
        .form-title {
            font-weight: 600;
            letter-spacing: 0.5px;
        }
        
        .form-label {
            font-weight: 500;
            color: var(--primary-color);
            margin-bottom: 8px;
        }
        
        .form-control, .form-select {
            border: 1px solid #d0c0c0;
            border-radius: 8px;
            padding: 10px 15px;
            transition: all 0.3s ease;
        }
        
        .form-control:focus, .form-select:focus {
            border-color: var(--primary-color);
            box-shadow: 0 0 0 0.25rem rgba(128, 0, 32, 0.15);
        }
        
        .btn-primary {
            background-color: var(--primary-color);
            border-color: var(--primary-color);
            padding: 10px 25px;
            border-radius: 8px;
            font-weight: 500;
            letter-spacing: 0.5px;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background-color: #600000;
            border-color: #600000;
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(128, 0, 32, 0.2);
        }
        
        .card {
            border: none;
            border-radius: 10px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            margin-bottom: 20px;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
        }
        
        .card-header {
            background-color: var(--primary-color);
            color: white;
            border-radius: 10px 10px 0 0 !important;
            padding: 15px;
            font-weight: 500;
        }
        
        .badge-prof {
            background-color: rgba(128, 0, 32, 0.1);
            color: var(--primary-color);
            font-weight: 500;
            padding: 5px 10px;
            border-radius: 20px;
            margin-right: 8px;
            margin-bottom: 8px;
            display: inline-block;
        }
        
        .badge-prof i {
            margin-right: 5px;
        }
        
        .table th {
            background-color: var(--light-bg);
            color: var(--primary-color);
            font-weight: 500;
        }
        
        @media (max-width: 768px) {
            .form-container {
                padding: 20px;
            }
            
            .form-header {
                padding: 15px;
            }
        }
    </style>
</head>
<body>
    <div class="container py-5">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="form-container">
                    <!-- En-tête du formulaire -->
                    <div class="form-header">
                        <h2 class="form-title"><i class="fas fa-chalkboard-teacher me-2"></i>cette page est en cours de developpement</h2>
                    </div>
                    
                   

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Script pour gérer la dynamique du formulaire
        document.getElementById('attributionForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Récupération des valeurs
            const annee = document.getElementById('anneeScolaire').value;
            const niveau = document.getElementById('niveau').value;
            const classe = document.getElementById('classe').value;
            const professeur = document.getElementById('professeur').value;
            const matiere = document.getElementById('matiere').value;
            const heures = document.getElementById('heures').value;
            
            // Ici, vous ajouteriez le code pour envoyer les données au serveur
            console.log('Enregistrement :', { annee, niveau, classe, professeur, matiere, heures });
            
            // Affichage d'une notification
            alert('Attribution enregistrée avec succès !');
            
            // Réinitialisation du formulaire
            this.reset();
        });
        
        // Dynamique des sélecteurs
        document.getElementById('niveau').addEventListener('change', function() {
            const niveau = this.value;
            const classeSelect = document.getElementById('classe');
            
            // Réinitialiser les options
            classeSelect.innerHTML = '<option value="" selected disabled>Sélectionner une classe...</option>';
            
            // Ajouter les options en fonction du niveau
            if (niveau === 'maternelle') {
                addOption(classeSelect, 'PS', 'Petite Section');
                addOption(classeSelect, 'MS', 'Moyenne Section');
                addOption(classeSelect, 'GS', 'Grande Section');
            } else if (niveau === 'primaire') {
                addOption(classeSelect, 'CP1', 'CP1');
                addOption(classeSelect, 'CP2', 'CP2');
                addOption(classeSelect, 'CE1', 'CE1');
                addOption(classeSelect, 'CE2', 'CE2');
                addOption(classeSelect, 'CM1', 'CM1');
                addOption(classeSelect, 'CM2', 'CM2');
            } else if (niveau === 'college') {
                addOption(classeSelect, '6eme', '6ème');
                addOption(classeSelect, '5eme', '5ème');
                addOption(classeSelect, '4eme', '4ème');
                addOption(classeSelect, '3eme', '3ème');
            } else if (niveau === 'lycee') {
                addOption(classeSelect, '2nde', '2nde');
                addOption(classeSelect, '1ere', '1ère');
                addOption(classeSelect, 'Terminale', 'Terminale');
            }
        });
        
        function addOption(selectElement, value, text) {
            const option = document.createElement('option');
            option.value = value;
            option.textContent = text;
            selectElement.appendChild(option);
        }
    </script>
</body>
</html>