<?php
session_start();
$userprofil = $_SESSION['user'] ?? null;
if (!$userprofil) {
    header("Location: login.php");
    exit();
}
include('includes/header.php');
require_once "includes/dbconn.php";

// Année en cours
$annee_courante = date('Y');
$mois_courant = date('m');

// Requête pour récupérer les étudiants irréguliers (non à jour)
// Ici on suppose que si l'étudiant a payé moins de $mois_courant mois dans la table mensualites, il est irrégulier.
$sql = "
    SELECT e.id, e.matricule, e.noms, e.prenom, cl.nom AS classe, e.phone
    FROM etudiants e
    LEFT JOIN classes cl ON e.classe_id = cl.id
    WHERE (
        SELECT COUNT(DISTINCT m.mois)
        FROM mensualites m
        WHERE m.etudiant_id = e.id
    ) < $mois_courant
    ORDER BY e.noms ASC
";

$result = $conn->query($sql);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <title>Étudiants irréguliers - Mise en demeure</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
    /* Styles pour la lettre dans le modal et à l'impression */
    #lettreContent {
      font-family: 'Times New Roman', serif;
      font-size: 16px;
      line-height: 1.5;
      color: #333;
      background: #fff;
      padding: 20px;
      border: 1px solid #ddd;
      border-radius: 8px;
      max-height: 80vh;
      overflow-y: auto;
    }
    #lettreContent header {
      text-align: center;
      margin-bottom: 20px;
    }
    #lettreContent header img {
      max-height: 80px;
      margin-bottom: 10px;
    }
    #lettreContent header h1 {
      margin: 0;
      font-size: 20px;
      font-weight: bold;
      text-transform: uppercase;
      color: #004085;
    }
    #lettreContent header p {
      margin: 2px 0;
      font-size: 14px;
      color: #555;
    }
    #lettreContent .date {
      text-align: right;
      margin-bottom: 20px;
      font-style: italic;
      color: #666;
    }
    #lettreContent .objet {
      font-weight: bold;
      margin-bottom: 15px;
      text-decoration: underline;
      color: #004085;
    }
    #lettreContent .corps {
      margin-bottom: 25px;
      white-space: pre-wrap;
    }
    #lettreContent footer {
      text-align: center;
      font-weight: bold;
      color: #004085;
      margin-top: 30px;
    }

    /* Impression */
    @media print {
      body * {
        visibility: hidden;
      }
      #modalMiseDemeure, #modalMiseDemeure * {
        visibility: visible;
      }
      #modalMiseDemeure {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
      }
      #btnPrintLettre, .btn-close {
        display: none !important;
      }
    }
  </style>
</head>
<body>
<div class="container py-5">
  <h2 class="mb-4 text-center">📋 Étudiants irréguliers (non à jour des paiements) - Année <?= $annee_courante ?></h2>

  <?php if ($result && $result->num_rows > 0): ?>
    <div class="table-responsive">
      <table class="table table-striped table-bordered align-middle">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Matricule</th>
            <th>Nom</th>
            <th>Prénom</th>
            <th>Classe</th>
            <th>Téléphone</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php
          $i = 1;
          while ($row = $result->fetch_assoc()) {
              $etudiant_json = htmlspecialchars(json_encode([
                'matricule' => $row['matricule'],
                'noms' => $row['noms'],
                'prenom' => $row['prenom'],
                'classe' => $row['classe'],
                'phone' => $row['phone'],
              ]), ENT_QUOTES, 'UTF-8');

              echo "<tr>
                <td>{$i}</td>
                <td>{$row['matricule']}</td>
                <td>{$row['noms']}</td>
                <td>{$row['prenom']}</td>
                <td>{$row['classe']}</td>
                <td>{$row['phone']}</td>
                <td>
                  <button type='button' class='btn btn-warning btn-sm btn-mise-demeure' data-etudiant='{$etudiant_json}'>
                    Mise en demeure
                  </button>
                </td>
              </tr>";
              $i++;
          }
          ?>
        </tbody>
      </table>
    </div>
  <?php else: ?>
    <div class="alert alert-success text-center">
      Tous les étudiants sont à jour dans leurs paiements pour cette année.
    </div>
  <?php endif; ?>
</div>

<!-- Modal Mise en demeure -->
<div class="modal fade" id="modalMiseDemeure" tabindex="-1" aria-labelledby="modalMiseDemeureLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-scrollable">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalMiseDemeureLabel">Lettre de mise en demeure</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fermer"></button>
      </div>
      <div class="modal-body">
        <div id="lettreContent">
          <!-- Le contenu de la lettre sera injecté ici -->
        </div>
      </div>
      <div class="modal-footer">
        <button id="btnPrintLettre" type="button" class="btn btn-primary">Imprimer</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
  const modalElement = document.getElementById('modalMiseDemeure');
  const modal = new bootstrap.Modal(modalElement);
  const lettreDiv = document.getElementById('lettreContent');
  const btnPrint = document.getElementById('btnPrintLettre');

  document.querySelectorAll('.btn-mise-demeure').forEach(btn => {
    btn.addEventListener('click', () => {
      const etudiant = JSON.parse(btn.getAttribute('data-etudiant'));
      const dateToday = new Date().toLocaleDateString('fr-FR');

      const lettreHtml = `
        <header>
          <img src="assetss/logo.jpeg" alt="Logo de l'école" />
          <h1>ECOLE SINE SALOUM SANTE</h1>
          <p>Lot 167, Leon Kaolack</p>
          <p>Téléphone : 33 941 00 08 | Email : giesinesaloum@gmail.com</p>
        </header>
        <div class="date">Paris, le ${dateToday}</div>
        <div>
          <p><strong>À :</strong> ${etudiant.noms} ${etudiant.prenom}</p>
          <p><strong>Classe :</strong> ${etudiant.classe}</p>
          <p><strong>Matricule :</strong> ${etudiant.matricule}</p>
          <p><strong>Téléphone :</strong> ${etudiant.phone}</p>
        </div>
        <h3 class="objet">Objet : Mise en demeure pour régularisation des paiements</H3>
        <div class="corps">
          Madame, Monsieur,<br><br>

          Nous constatons que vous n'avez pas régularisé vos paiements de scolarité pour plusieurs mois de l'année en cours.<br> Nous vous demandons de bien vouloir procéder au règlement dans les plus brefs délais afin d'éviter toute mesure administrative.<br><br>

          Nous restons à votre disposition pour toute information complémentaire.<br><br>

          Veuillez agréer, Madame, Monsieur, l'expression de nos salutations distinguées.<br><br>
        </div>
       
      `;

      lettreDiv.innerHTML = lettreHtml;
      modal.show();
    });
  });

  btnPrint.addEventListener('click', () => {
    const printContents = lettreDiv.innerHTML;
    const printWindow = window.open('', '', 'height=700,width=900');
    printWindow.document.write(`
      <html>
      <head>
        <title>Imprimer lettre de mise en demeure</title>
        <style>
          body { font-family: 'Times New Roman', serif; margin: 40px; color: #333; }
          header { text-align: center; margin-bottom: 20px; }
          header img { max-height: 80px; margin-bottom: 10px; }
          header h1 { margin: 0; font-size: 20px; font-weight: bold; text-transform: uppercase; color: #004085; }
          header p { margin: 2px 0; font-size: 14px; color: #555; }
          .date { text-align: right; margin-bottom: 20px; font-style: italic; color: #666; }
          .objet { font-weight: bold; margin-bottom: 15px; text-decoration: underline; color: #004085; }
          .corps { margin-bottom: 25px; white-space: pre-wrap; }
          footer { text-align: center; font-weight: bold; color: #004085; margin-top: 30px; }
        </style>
      </head>
      <body>${printContents}</body>
      </html>
    `);
    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
    printWindow.close();
  });
});
</script>
</body>
</html>
