<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Bulletin de Notes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.8.1/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        @page {
            size: A4 portrait;
            margin: 10mm;
        }
        body {
            font-family: 'Segoe UI', 'Roboto', sans-serif;
            font-size: 13px;
            color: #333;
            background-color: #fff;
            line-height: 1.4;
        }
        .header {
            text-align: center;
            margin-bottom: 20px;
            padding-bottom: 15px;
            border-bottom: 3px double #8B0000;
            position: relative;
        }
        .school-name {
            color: #8B0000;
            font-weight: 700;
            letter-spacing: 0.5px;
            font-size: 1.4rem;
            margin-bottom: 5px;
        }
        .header::after {
            content: "";
            display: block;
            width: 100px;
            height: 2px;
            background: #8B0000;
            margin: 8px auto;
        }
        .student-card {
            background: linear-gradient(to right, #FFF8F8, #FFFFFF);
            border-radius: 8px;
            padding: 15px;
            margin-bottom: 20px;
            box-shadow: 0 2px 10px rgba(139, 0, 0, 0.08);
            border-left: 4px solid #8B0000;
        }
        .student-name {
            color: #8B0000;
            font-weight: 600;
            font-size: 1.1rem;
        }
        .table-container {
            margin-bottom: 20px;
            overflow: hidden;
            border-radius: 8px;
            box-shadow: 0 1px 15px rgba(0, 0, 0, 0.05);
        }
        .table {
            margin-bottom: 0;
        }
        .table thead {
            background: #8B0000;
            color: white;
        }
        .table th {
            font-weight: 500;
            padding: 8px 10px;
            vertical-align: middle;
        }
        .table td {
            padding: 7px 10px;
            vertical-align: middle;
        }
        .table-hover tbody tr:hover {
            background-color: rgba(139, 0, 0, 0.03);
        }
        .appreciation-badge {
            padding: 4px 8px;
            border-radius: 12px;
            font-size: 0.75rem;
            font-weight: 500;
        }
        .total-row {
            background-color: #F8F1F1 !important;
            font-weight: 600;
        }
        .signature-area {
            margin-top: 30px;
            padding-top: 15px;
            text-align: right;
        }
        .footer {
            font-size: 0.8rem;
            color: #777;
            text-align: center;
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px solid #EEE;
        }
        .grade-box {
            display: inline-block;
            width: 24px;
            height: 24px;
            line-height: 24px;
            text-align: center;
            border-radius: 4px;
            margin-right: 3px;
            font-size: 0.8rem;
            font-weight: 500;
        }
        .subject-name {
            font-weight: 500;
        }
        .watermark {
            position: absolute;
            opacity: 0.03;
            font-size: 120px;
            font-weight: bold;
            color: #8B0000;
            transform: rotate(-30deg);
            z-index: -1;
            left: 50px;
            top: 300px;
        }
    </style>
</head>
<body>
    <div class="container-fluid position-relative">
        <div class="watermark">SINE SALOUM</div>
        
        <!-- En-tête élégant -->
        <div class="header">
            <div class="school-name">ECOLE SINE SALOUM SANTE</div>
            <div class="text-muted mb-1">Institut de Formation en Santé</div>
            <div><small>Tél. 33 941.00.08 | Quartier Leona Lot N° 167 Kaolack</small></div>
        </div>

        <!-- Carte étudiante -->
        <div class="student-card">
            <div class="row">
                <div class="col-md-8">
                    <h5 class="student-name mb-2"><i class="bi bi-person-circle me-2"></i>FATOU THIAM</h5>
                    <div class="d-flex">
                        <div class="me-4">
                            <div><i class="bi bi-book me-2"></i><strong>Section:</strong> Déléguée Médicale</div>
                        </div>
                        <div>
                            <div><i class="bi bi-people me-2"></i><strong>Effectif:</strong> 50</div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 text-end">
                    <div class="d-inline-block px-3 py-2 rounded" style="background-color: #F8F1F1; border: 1px solid #E0D0D0;">
                        <div class="text-muted small">Moyenne Semestrielle</div>
                        <div class="h4 mb-0" style="color: #8B0000;">11.07<span class="small">/20</span></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Tableau des notes -->
        <div class="table-container">
            <table class="table table-hover table-bordered">
                <thead>
                    <tr>
                        <th style="width: 25%;">Matières</th>
                        <th class="text-center">Devoirs</th>
                        <th class="text-center">Moy. Dev</th>
                        <th class="text-center">Comp.</th>
                        <th class="text-center">Moy. Gén.</th>
                        <th class="text-center">Coef.</th>
                        <th class="text-center">Total</th>
                        <th class="text-center">Appréciation</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="subject-name">Pharmacologie</td>
                        <td class="text-center">
                            <span class="grade-box" style="background-color: #F3E8E8;">10.83</span>
                            <span class="grade-box" style="background-color: #F3E8E8;">10.83</span>
                        </td>
                        <td class="text-center">10.83</td>
                        <td class="text-center"></td>
                        <td class="text-center">10.83</td>
                        <td class="text-center">2</td>
                        <td class="text-center">21.66</td>
                        <td class="text-center"><span class="appreciation-badge" style="background-color: #FFF3CD; color: #856404;">Passable</span></td>
                    </tr>
                    <tr>
                        <td class="subject-name">Marketing</td>
                        <td class="text-center">
                            <span class="grade-box" style="background-color: #E7F5F5;">12</span>
                            <span class="grade-box" style="background-color: #E7F5F5;">12</span>
                        </td>
                        <td class="text-center">12</td>
                        <td class="text-center"></td>
                        <td class="text-center">12</td>
                        <td class="text-center">2</td>
                        <td class="text-center">24</td>
                        <td class="text-center"><span class="appreciation-badge" style="background-color: #D1ECF1; color: #0C5460;">Assez Bien</span></td>
                    </tr>
                    <tr>
                        <td class="subject-name">Droit</td>
                        <td class="text-center">
                            <span class="grade-box" style="background-color: #E7F5F5;">15</span>
                            <span class="grade-box" style="background-color: #F3E8E8;">12</span>
                        </td>
                        <td class="text-center">13.5</td>
                        <td class="text-center"></td>
                        <td class="text-center">13.5</td>
                        <td class="text-center">2</td>
                        <td class="text-center">27</td>
                        <td class="text-center"><span class="appreciation-badge" style="background-color: #D1ECF1; color: #0C5460;">Assez Bien</span></td>
                    </tr>
                    <tr>
                        <td class="subject-name">Méthodologie du Travail</td>
                        <td class="text-center">
                            <span class="grade-box" style="background-color: #E8F5E9;">19</span>
                            <span class="grade-box" style="background-color: #E8F5E9;">19</span>
                        </td>
                        <td class="text-center">19</td>
                        <td class="text-center"></td>
                        <td class="text-center">19</td>
                        <td class="text-center">2</td>
                        <td class="text-center">38</td>
                        <td class="text-center"><span class="appreciation-badge" style="background-color: #D4EDDA; color: #155724;">Très Bien</span></td>
                    </tr>
                    <tr>
                        <td class="subject-name">Pathologie</td>
                        <td class="text-center">
                            <span class="grade-box" style="background-color: #F3E8E8;">12</span>
                            <span class="grade-box" style="background-color: #FCE8E8;">5</span>
                        </td>
                        <td class="text-center">8.5</td>
                        <td class="text-center"></td>
                        <td class="text-center">8.5</td>
                        <td class="text-center">2</td>
                        <td class="text-center">17</td>
                        <td class="text-center"><span class="appreciation-badge" style="background-color: #F8D7DA; color: #721C24;">Échec</span></td>
                    </tr>
                    <tr class="total-row">
                        <td colspan="5" class="text-end"><strong>Totaux</strong></td>
                        <td class="text-center"><strong>24</strong></td>
                        <td class="text-center"><strong>265.66</strong></td>
                        <td class="text-center"><strong>Moyenne: 11.07</strong></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <!-- Appréciations et mentions -->
        <div class="row">
            <div class="col-md-6">
                <div class="card border-0 shadow-sm mb-3">
                    <div class="card-header bg-white border-bottom-0">
                        <h6 class="mb-0" style="color: #8B0000;"><i class="bi bi-clipboard-check me-2"></i>Appréciations Générales</h6>
                    </div>
                    <div class="card-body">
                        <div class="row mb-2">
                            <div class="col-4"><strong>Travail</strong></div>
                            <div class="col-8">
                                <span class="badge rounded-pill me-1" style="background-color: #8B0000;">TB</span>
                                <span class="badge rounded-pill me-1 bg-secondary">B</span>
                                <span class="badge rounded-pill me-1 bg-light text-dark">AB</span>
                                <span class="badge rounded-pill bg-light text-dark">P</span>
                            </div>
                        </div>
                        <div class="row mb-2">
                            <div class="col-4"><strong>Conduite</strong></div>
                            <div class="col-8">
                                <span class="badge rounded-pill me-1" style="background-color: #8B0000;">TB</span>
                                <span class="badge rounded-pill me-1 bg-secondary">B</span>
                                <span class="badge rounded-pill me-1 bg-light text-dark">AB</span>
                                <span class="badge rounded-pill bg-light text-dark">PX</span>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-4"><strong>Assiduité</strong></div>
                            <div class="col-8">
                                <span class="badge rounded-pill me-1" style="background-color: #8B0000;">TB</span>
                                <span class="badge rounded-pill me-1 bg-secondary">B</span>
                                <span class="badge rounded-pill me-1 bg-light text-dark">AB</span>
                                <span class="badge rounded-pill bg-light text-dark">PX</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card border-0 shadow-sm">
                    <div class="card-header bg-white border-bottom-0">
                        <h6 class="mb-0" style="color: #8B0000;"><i class="bi bi-award me-2"></i>Mentions</h6>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-between mb-2">
                            <span>1. Félicitation</span>
                            <span class="badge rounded-circle" style="background-color: #8B0000; width: 22px; height: 22px;"></span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>2. Encouragement</span>
                            <span class="badge rounded-circle" style="background-color: #8B0000; width: 22px; height: 22px;">1</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span>3. Tableau d'honneur</span>
                            <span class="badge rounded-circle" style="background-color: #8B0000; width: 22px; height: 22px;">2</span>
                        </div>
                        <div class="d-flex justify-content-between">
                            <span>4. Avertissement</span>
                            <span class="badge rounded-circle" style="background-color: #8B0000; width: 22px; height: 22px;">3</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Signature -->
        <div class="signature-area">
            <div class="d-flex justify-content-between align-items-end">
                <div style="width: 200px; border-top: 1px solid #8B0000; padding-top: 5px; text-align: center;">
                    <small class="text-muted">Cachet de l'établissement</small>
                </div>
                <div>
                    <div class="mb-1">Kaolack, le _________________________</div>
                    <div style="margin-top: 40px; border-top: 1px solid #8B0000; display: inline-block; padding-top: 5px;">
                        <strong style="color: #8B0000;">Le Directeur</strong>
                    </div>
                </div>
            </div>
        </div>

        <!-- Pied de page -->
        <div class="footer">
            <small>Bulletin généré le 08/08/2024 - École Sine Saloum Santé © 2024</small>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>