<?php
session_start();
require 'includes/dbconn.php';

// ⚙️ Étape 1 : Récupérer les données de l'étudiant via matricule
$etudiant = null;
if (isset($_GET['matricule'])) {
    $matricule = $_GET['matricule'];
    $sql = "SELECT e.id, e.matricule, e.noms, e.prenom, c.id AS classe_id, c.nom AS classe, n.nom AS niveau
            FROM etudiants e
            JOIN classes c ON e.classe_id = c.id
            JOIN niveaux n ON c.niveau_id = n.id
            WHERE e.matricule = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $matricule);
    $stmt->execute();
    $result = $stmt->get_result();
    $etudiant = $result->fetch_assoc();
}

// ⚙️ Étape 2 : Traitement du formulaire à la soumission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['valider'])) {
    $matricule = $_POST['matricule'];
    $montant = floatval($_POST['montant']);

    // 💾 Insertion dans la table reinscriptions
    $stmt = $conn->prepare("INSERT INTO reinscriptions (matricule, montant, date_reinscription) VALUES (?, ?, NOW())");
    $stmt->bind_param("sd", $matricule, $montant);
    if ($stmt->execute()) {
        echo "<div style='color: green; font-weight: bold;'>✅ Réinscription enregistrée avec succès.</div>";
    } else {
        echo "<div style='color: red;'>❌ Erreur lors de l'enregistrement.</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Réinscription Étudiant</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-5">
    <h3 class="mb-4">📋 Formulaire de Réinscription</h3>

    <?php if ($etudiant): ?>
        <form method="POST">
            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Matricule</label>
                    <input type="text" name="matricule" class="form-control" value="<?= htmlspecialchars($etudiant['matricule']) ?>" readonly>
                </div>
                <div class="col-md-6">
                    <label>Nom</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['nom']) ?>" readonly>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Prénom</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['prenom']) ?>" readonly>
                </div>
                <div class="col-md-6">
                    <label>Classe Actuelle</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['classe']) ?>" readonly>
                </div>
            </div>

            <div class="row mb-3">
                <div class="col-md-6">
                    <label>Niveau</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['niveau']) ?>" readonly>
                </div>
                <div class="col-md-6">
                    <label>Montant à payer</label>
                    <input type="number" name="montant" class="form-control" required>
                </div>
            </div>

            <button type="submit" name="valider" class="btn btn-success me-2">Valider la Réinscription</button>
            <a href="listeEtudiants.php" class="btn btn-secondary">Annuler</a>
        </form>
    <?php else: ?>
        <div class="alert alert-danger">Étudiant introuvable. <a href="listeEtudiants.php">Retour</a></div>
    <?php endif; ?>
</body>
</html>
