<?php
session_start();
require('includes/dbconn.php');

if (!isset($_GET['matricule'])) {
    // Pas de matricule, on redirige ou affiche une erreur
    header('Location: liste_etudiants.php');
    exit;
}

$matricule = $_GET['matricule'];

// Récupérer les infos de l'étudiant en base
$sql = "SELECT e.*, c.noms AS nom_classe, n.nom AS nom_niveau 
        FROM etudiants e
        LEFT JOIN classes c ON e.classe_id = c.id
        LEFT JOIN niveaux n ON c.niveau_id = n.id
        WHERE e.matricule = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $matricule);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo "Étudiant non trouvé.";
    exit;
}

$etudiant = $result->fetch_assoc();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Réinscription étudiant</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4">
    <h2>Réinscription de l'étudiant</h2>

    <form action="valider_reinscription.php" method="post" class="row g-3">
        <!-- Champs préremplis (en readonly) -->
        <div class="col-md-6">
            <label class="form-label">Matricule</label>
            <input type="text" name="matricule" class="form-control" value="<?= htmlspecialchars($etudiant['matricule']) ?>" readonly />
        </div>
        <div class="col-md-6">
            <label class="form-label">Nom complet</label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['nom_complet']) ?>" readonly />
        </div>
        <div class="col-md-6">
            <label class="form-label">Niveau actuel</label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['nom_niveau']) ?>" readonly />
        </div>
        <div class="col-md-6">
            <label class="form-label">Classe actuelle</label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($etudiant['nom_classe']) ?>" readonly />
        </div>

        <!-- Champ pour sélectionner la nouvelle classe (classe de destination) -->
        <div class="col-md-6">
            <label for="classe_destination" class="form-label">Classe de destination</label>
            <select name="classe_destination" id="classe_destination" class="form-select" required>
                <option value="">-- Sélectionner --</option>
                <?php
                // Récupérer toutes les classes pour sélection
                $classes = $conn->query("SELECT id, nom FROM classes ORDER BY nom");
                while ($cls = $classes->fetch_assoc()) {
                    echo '<option value="' . $cls['id'] . '">' . htmlspecialchars($cls['nom']) . '</option>';
                }
                ?>
            </select>
        </div>

        <!-- Champ montant (vide à remplir) -->
        <div class="col-md-6">
            <label for="montant" class="form-label">Montant à payer</label>
            <input type="number" name="montant" id="montant" class="form-control" required min="0" step="0.01" />
        </div>

        <!-- Boutons valider et annuler -->
        <div class="col-12 mt-3">
            <button type="submit" class="btn btn-success me-2">Valider la réinscription</button>
            <a href="liste_etudiants.php" class="btn btn-secondary">Annuler</a>
        </div>
    </form>
</div>
</body>
</html>
