<?php 
session_start();
$userprofil = $_SESSION['user'];
if ($userprofil == true) {
    include('includes/header.php');
    require_once "includes/dbconn.php";
} else {
    header("Location: login.php");
    exit();
}

// Étudiants
$sql_etudiants = "SELECT COUNT(*) as total_etudiants FROM etudiants";
$result_etudiants = $conn->query($sql_etudiants);
$nombreTotalEtudiants = ($result_etudiants && $result_etudiants->num_rows > 0) ? $result_etudiants->fetch_assoc()['total_etudiants'] : 0;

// Classes
$sql_classes = "SELECT COUNT(*) as total_classes FROM classes";
$result_classes = $conn->query($sql_classes);
$nombreClasses = ($result_classes && $result_classes->num_rows > 0) ? $result_classes->fetch_assoc()['total_classes'] : 0;

// Professeurs
$sql_profs = "SELECT COUNT(*) as total_profs FROM enseignants";
$result_profs = $conn->query($sql_profs);
$nombreProfs = ($result_profs && $result_profs->num_rows > 0) ? $result_profs->fetch_assoc()['total_profs'] : 0;

// Revenus & Dépenses
$total_revenu = 0;
$total_depense = 0;

$query_rev = "
    SELECT SUM(montant) AS total FROM caisse WHERE type = 'revenu'
    UNION ALL
    SELECT SUM(montant) AS total FROM mensualites
";
$result_rev = $conn->query($query_rev);
while ($row = $result_rev->fetch_assoc()) {
    $total_revenu += $row['total'];
}

$result_dep = $conn->query("SELECT SUM(montant) AS total FROM caisse WHERE type = 'depense'");
$row_dep = $result_dep->fetch_assoc();
$total_depense = $row_dep['total'] ?? 0;
$solde = $total_revenu - $total_depense;

// Nombre d'étudiants inscrits pour 2025-2026
$sql_inscrits_2025 = "SELECT COUNT(*) as total_inscrits FROM etudiants WHERE annee_academique = '2025-2026'";
$result_inscrits = $conn->query($sql_inscrits_2025);
$total_inscrits_2025 = ($result_inscrits && $result_inscrits->num_rows > 0) ? $result_inscrits->fetch_assoc()['total_inscrits'] : 0;
?>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
    body {
        background-color: #f8f9fa;
    }
    .dashboard-container {
        padding: 20px;
    }
    .card-custom {
        background-color: #1a5276;
        color: white;
        border: none;
        border-radius: 1rem;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
        padding: 10px 15px;
    }
    .card-custom:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 24px rgba(0,0,0,0.2);
    }
    .card-icon {
        font-size: 1.8rem;
    }
    .card-custom h6 {
        font-size: 0.95rem;
        margin-bottom: 0.3rem;
    }
    .card-custom h2 {
        font-size: 1.4rem;
        margin-bottom: 0.5rem;
    }
    .inscription-card {
        background: linear-gradient(135deg, #1a7f76 0%, #1a5276 100%);
        border-radius: 1rem;
        box-shadow: 0 4px 20px rgba(26, 127, 118, 0.2);
    }
    .inscription-count {
        font-size: 3.5rem;
        font-weight: 800;
        color: #a8e6cf;
        line-height: 1;
        text-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
    .btn-inscription {
        background-color: rgba(255,255,255,0.9);
        color: #1a5276;
        font-weight: 600;
        border: none;
        transition: all 0.3s ease;
    }
    .btn-inscription:hover {
        background-color: white;
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
</style>

<div class="container dashboard-container">
    <div class="row g-3">
        <div class="col-sm-6 col-md-3">
            <div class="card card-custom text-center">
                <div class="card-icon mb-1"><i class="fas fa-school"></i></div>
                <h6>Nombre de Classes</h6>
                <h2><?= $nombreClasses ?></h2>
                <a href="listClasse.php" class="stretched-link text-white text-decoration-underline">Voir plus</a>
            </div>
        </div>

        <div class="col-sm-6 col-md-3">
            <div class="card card-custom text-center">
                <div class="card-icon mb-1"><i class="fas fa-user-graduate"></i></div>
                <h6>Total Élèves</h6>
                <h2><?= $nombreTotalEtudiants ?></h2>
                <a href="views-student.php" class="stretched-link text-white text-decoration-underline">Voir plus</a>
            </div>
        </div>

        <div class="col-sm-6 col-md-3">
            <div class="card card-custom text-center">
                <div class="card-icon mb-1"><i class="fas fa-chalkboard-teacher"></i></div>
                <h6>Total Enseignants</h6>
                <h2><?= $nombreProfs ?></h2>
                <a href="list_prof.php" class="stretched-link text-white text-decoration-underline">Voir plus</a>
            </div>
        </div>

        <div class="col-sm-6 col-md-3">
            <div class="card card-custom text-center">
                <div class="card-icon mb-1"><i class="fas fa-wallet"></i></div>
                <h6>Solde Caisse</h6>
                <h2><?= number_format($solde, 0, ',', ' ') ?> F</h2>
                <a href="caisses.php" class="stretched-link text-white text-decoration-underline">Voir plus</a>
            </div>
        </div>
    </div>

    <div class="row mt-5 align-items-center">
        <div class="col-md-7">
            <h5 class="text-center mb-3">📊 Graphique Caisse</h5>
            <canvas id="caisseChart" height="150"></canvas>
        </div>
        <div class="col-md-5">
            <div class="card border-0 inscription-card">
                <div class="card-body text-center p-4">
                    <h5 class="text-white mb-3" style="font-weight: 600;">
                        <i class="fas fa-calendar-check me-2"></i> INSCRIPTIONS 2025-2026
                    </h5>
                    <div class="d-flex justify-content-center align-items-center mb-3">
                        <div class="inscription-count">
                            <?= $total_inscrits_2025 ?>
                        </div>
                        <div class="ms-2" style="font-size: 1.2rem; color: rgba(255,255,255,0.8);">
                            élèves
                        </div>
                    </div>
                    <a href="views-student.php?annee=2025-2026" class="btn btn-inscription btn-lg mt-2 px-4 rounded-pill">
                        Voir la liste <i class="fas fa-arrow-right ms-2"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('caisseChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['Revenus', 'Dépenses', 'Solde'],
            datasets: [{
                label: 'Montant (F CFA)',
                data: [<?= $total_revenu ?>, <?= $total_depense ?>, <?= $solde ?>],
                backgroundColor: 'rgba(15, 165, 9, 0.2)',
                borderColor: 'rgba(9, 114, 89, 1)',
                borderWidth: 3,
                pointBackgroundColor: '#b8b8b8ff',
                pointRadius: 6,
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: { display: false },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return new Intl.NumberFormat('fr-FR', {
                                style: 'currency',
                                currency: 'XOF'
                            }).format(context.parsed.y);
                        }
                    }
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        callback: function(value) {
                            return new Intl.NumberFormat('fr-FR').format(value) + ' F';
                        }
                    }
                }
            }
        }
    });
</script>

<?php include 'includes/footer.php'; ?>