<?php 
session_start();
$userprofil = $_SESSION['user'];
if ($userprofil == true) {
    include('includes/header.php');
    require_once "includes/dbconn.php";
} else {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['id'])) {
    echo "<div class='alert alert-warning'>ID de classe non fourni.</div>";
    exit;
}

$idClasse = intval($_GET['id']);

$query = "
    SELECT c.nom AS nom_classe, c.date_creation, n.nom_niveau AS niveau, 
           (SELECT COUNT(*) FROM etudiants e WHERE e.classe_id = c.id) AS total_etudiants
    FROM classes c
    JOIN niveaux n ON c.niveau_id = n.id
    WHERE c.id = $idClasse
    LIMIT 1
";

$res = mysqli_query($conn, $query);
$classe = mysqli_fetch_assoc($res);

if (!$classe) {
    echo "<div class='alert alert-danger'>Classe introuvable.</div>";
    exit;
}

// Récupérer les étudiants de la classe
$queryEtudiants = "
    SELECT prenom, noms, date_de_naissance, lieu_de_naissance,matricule, adresse
    FROM etudiants
    WHERE classe_id = $idClasse
    ORDER BY noms, prenom
";
$resEtudiants = mysqli_query($conn, $queryEtudiants);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Détails de la Classe</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <style>
        :root {
            --vert-primaire: #2E8B57;
            --vert-secondaire: #3CB371;
            --bleu-primaire: #1E88E5;
            --bleu-secondaire: #42A5F5;
            --blanc-creme: #F8F9FA;
            --gris-clair: #E9ECEF;
            --noir-texte: #212529;
            --degrade-vert: linear-gradient(135deg, var(--vert-primaire), var(--vert-secondaire));
            --degrade-bleu: linear-gradient(135deg, var(--bleu-primaire), var(--bleu-secondaire));
        }
        
        body {
            background-color: var(--blanc-creme);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            color: var(--noir-texte);
        }
        
        .container {
            max-width: 95%;
            margin-top: 2rem;
        }
        
        .page-title {
            color: var(--vert-primaire);
            font-weight: 700;
            text-transform: uppercase;
            letter-spacing: 1px;
            position: relative;
            padding-bottom: 0.8rem;
            margin-bottom: 2rem;
        }
        
        .page-title::after {
            content: '';
            position: absolute;
            bottom: 0;
            left: 0;
            width: 100%;
            height: 3px;
            background: var(--degrade-vert);
            border-radius: 3px;
        }
        
        .btn-primary {
            background: var(--degrade-bleu);
            border: none;
            transition: all 0.3s ease;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 8px rgba(0, 0, 0, 0.15);
        }
        
        .btn-outline-primary {
            color: var(--bleu-primaire);
            border-color: var(--bleu-primaire);
            transition: all 0.3s ease;
        }
        
        .btn-outline-primary:hover {
            background: var(--degrade-bleu);
            color: white;
            border-color: transparent;
        }
        
        .card-header {
            background: var(--degrade-vert);
            color: white;
            font-weight: 600;
            border-radius: 0.375rem 0.375rem 0 0 !important;
        }
        
        .info-table {
            width: 100%;
        }
        
        .info-table th {
            width: 30%;
            color: var(--vert-primaire);
            font-weight: 600;
        }
        
        .badge-etudiants {
            background: var(--degrade-bleu);
            font-size: 1rem;
            padding: 0.5rem 1rem;
            border-radius: 50px;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.1);
        }
        
        .card {
            border: none;
            border-radius: 0.5rem;
            box-shadow: 0 10px 20px rgba(0, 0, 0, 0.08);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
            overflow: hidden;
        }
        
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.12);
        }
        
        /* Styles pour l'impression */
        @media print {
            * {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
            }
            
            body {
                font-size: 14px;
                margin: 0;
                background: white !important;
            }
            
            .print-title {
                color: var(--vert-primaire);
                text-align: center;
                margin-bottom: 20px;
                font-weight: 700;
            }
            
            .print-table {
                width: 100%;
                border-collapse: collapse;
            }
            
            .print-table, .print-table th, .print-table td {
                border: 1px solid #ddd;
            }
            
            .print-table th, .print-table td {
                padding: 8px;
                text-align: left;
            }
            
            .print-table thead {
                background-color: #f8f9fa !important;
                -webkit-print-color-adjust: exact;
            }
        }
        
        /* Modal styles */
        .modal-header {
            background: var(--degrade-vert);
            color: white;
        }
        
        .btn-close-white {
            filter: invert(1);
        }
        
        /* Effets modernes */
        .table-hover tbody tr {
            transition: all 0.2s ease;
        }
        
        .table-hover tbody tr:hover {
            background-color: rgba(46, 139, 87, 0.1);
            transform: scale(1.01);
        }
        
        /* Animation subtile */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }
        
        .card, .modal-content {
            animation: fadeIn 0.5s ease forwards;
        }
        
        /* Ombre portée moderne */
        .shadow-lg-modern {
            box-shadow: 0 15px 30px rgba(0, 0, 0, 0.1), 0 5px 15px rgba(0, 0, 0, 0.07);
        }
        
        /* Bordures arrondies */
        .rounded-lg {
            border-radius: 0.5rem;
        }
    </style>
</head>
<body>
<div class="container">
    <h1 class="page-title"><i class="fas fa-chalkboard-teacher me-2"></i>Détails de la Classe</h1>

    <a href="listClasse.php" class="btn btn-outline-primary mb-4 rounded-lg">
        <i class="fas fa-arrow-left me-1"></i> Retour à la liste
    </a>

    <div class="card shadow-lg-modern">
        <div class="card-header">
            <h4 class="mb-0"><i class="fas fa-info-circle me-2"></i>Informations de la classe</h4>
        </div>
        <div class="card-body">
            <table class="table table-borderless info-table">
                <tr>
                    <th>Nom de la classe :</th>
                    <td><strong><?= htmlspecialchars($classe['nom_classe']) ?></strong></td>
                </tr>
                <tr>
                    <th>Niveau :</th>
                    <td><?= htmlspecialchars($classe['niveau']) ?></td>
                </tr>
                <tr>
                    <th>Date de création :</th>
                    <td><?= date('d/m/Y', strtotime($classe['date_creation'])) ?></td>
                </tr>
                <tr>
                    <th>Étudiants inscrits :</th>
                    <td><span class="badge badge-etudiants"><?= $classe['total_etudiants'] ?> étudiant(s)</span></td>
                </tr>
            </table>
            
            <button class="btn btn-primary mt-3 rounded-lg" data-bs-toggle="modal" data-bs-target="#printModal">
                <i class="fas fa-print me-1"></i> Imprimer la liste
            </button>
        </div>
    </div>
</div>

<!-- Modal d'impression -->
<div class="modal fade" id="printModal" tabindex="-1" aria-labelledby="printModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-scrollable">
    <div class="modal-content shadow-lg-modern">
      <div class="modal-header">
        <h5 class="modal-title" id="printModalLabel">
            <i class="fas fa-users me-2"></i>Liste des étudiants - <?= htmlspecialchars($classe['nom_classe']) ?>
        </h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Fermer"></button>
      </div>
      <div class="modal-body" id="printableArea">
        <div class="text-center mb-4">
            <h3 class="mb-1">ECOLE SINE SALOUM SANTE</h3>
            <p class="mb-1">Kaolack, Leona lot 167</p>
            <p class="mb-3">Téléphone : 33 941 00 08 - Email : giesinesaloum@gmail.com</p>
            <h4 class="border-top border-bottom py-2" style="border-color: var(--vert-primaire) !important;">
                Liste des étudiants - <?= htmlspecialchars($classe['nom_classe']) ?> (<?= htmlspecialchars($classe['niveau']) ?>)
            </h4>
        </div>
        
        <table class="table print-table table-hover">
            <thead class="table-light">
                <tr>
                    <th>N°</th>
                    <th>Prénom</th>
                    <th>Nom</th>
                    <th>Matricule</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                mysqli_data_seek($resEtudiants, 0); // Réinitialiser le pointeur du résultat
                $i = 1;
                while ($etudiant = mysqli_fetch_assoc($resEtudiants)) : ?>
                    <tr>
                        <td><?= $i++ ?></td>
                        <td><?= htmlspecialchars($etudiant['prenom']) ?></td>
                        <td><?= htmlspecialchars($etudiant['noms']) ?></td>
                        <td><?= htmlspecialchars($etudiant['matricule']) ?></td>
                    </tr>
                <?php endwhile; ?>
                <?php if ($i === 1): ?>
                    <tr>
                        <td colspan="4" class="text-center text-muted py-4">
                            <i class="fas fa-user-slash me-2"></i>Aucun étudiant inscrit dans cette classe
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
        
        <div class="text-end mt-4">
            <p class="mb-1">Fait à Kaolack, le <?= date('d/m/Y') ?></p>
            <p class="mb-0">Le Responsable</p>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary rounded-lg" data-bs-dismiss="modal">
            <i class="fas fa-times me-1"></i> Fermer
        </button>
        <button type="button" class="btn btn-primary rounded-lg" onclick="printDiv('printableArea')">
            <i class="fas fa-print me-1"></i> Imprimer
        </button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function printDiv(divId) {
    const printContents = document.getElementById(divId).innerHTML;
    const originalContents = document.body.innerHTML;
    
    const printStyles = `
        <style>
            @page {
                size: A4 portrait;
                margin: 15mm;
            }
            body {
                font-family: Arial, sans-serif;
                font-size: 12pt;
                color: #000;
                background: white !important;
            }
            .text-center {
                text-align: center;
            }
            .text-end {
                text-align: right;
            }
            .mb-1 { margin-bottom: 0.25rem; }
            .mb-3 { margin-bottom: 1rem; }
            .mt-4 { margin-top: 1.5rem; }
            .py-2 { padding-top: 0.5rem; padding-bottom: 0.5rem; }
            .border-top { border-top: 1px solid #000; }
            .border-bottom { border-bottom: 1px solid #000; }
            table {
                width: 100%;
                border-collapse: collapse;
                margin: 20px 0;
                font-size: 11pt;
            }
            table, th, td {
                border: 1px solid #ddd;
            }
            th, td {
                padding: 8px;
                text-align: left;
            }
            thead {
                background-color: #f2f2f2 !important;
            }
        </style>
    `;
    
    const printWindow = window.open('', '', 'height=700,width=900');
    printWindow.document.write('<html><head><title>Liste des étudiants - <?= htmlspecialchars($classe['nom_classe']) ?></title>');
    printWindow.document.write(printStyles);
    printWindow.document.write('</head><body>');
    printWindow.document.write(printContents);
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    
    setTimeout(() => {
        printWindow.focus();
        printWindow.print();
    }, 500);
}
</script>
</body>
</html>