<?php if (isset($afficher_recu)): ?>
    <div class="card mx-auto" style="max-width: 600px;">
        <div class="card-body p-4">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <img src="assetss/logo.jpeg" alt="Logo École" style="height:60px;">
                    <p class="mb-0">E3S</p>
                    <p class="mb-0">Adresse: Kaolack, Leona, Lot 167</p>
                    <p class="mb-0">Tel: 33 941 00 08 | Email: giesinesaloum@gmail.com</p>
                </div>
                <div class="text-end">
                    <h2 class="text-white py-2 px-3 rounded" style="background-color: #800000;">📄 Reçu de Paiement</h2>
                    <p class="text-white fw-bold" style="background-color: #800000; margin-top: -10px;">
                        Numéro du reçu : <?= htmlspecialchars($_SESSION["numero_recu"]) ?>
                    </p>
                </div>
            </div>

            <table class="table table-bordered">
                <tbody>
                    <tr>
                        <th>Nom & prénom</th>
                        <td><?= htmlspecialchars($_SESSION["nom"]) ?> <?= htmlspecialchars($_SESSION["prenom"]) ?></td>
                        <th>Matricule</th>
                        <td><?= htmlspecialchars($_SESSION["matricule"]) ?></td>
                    </tr>
                    <tr>
                        <th>Classe / Niveau</th>
                        <td><?= htmlspecialchars($_SESSION["classe"]) ?> / <?= htmlspecialchars($_SESSION["niveau"]) ?></td>
                        <th>Année académique</th>
                        <td><?= htmlspecialchars($_SESSION["annee"]) ?></td>
                    </tr>
                    <tr>
                        <th>Date de paiement</th>
                        <td colspan="3"><?= date("d/m/Y") ?></td>
                    </tr>
                    <tr>
                        <th>Montant payé</th>
                        <td colspan="3" class="text-success fw-bold" style="font-size: 1.2em;">
                            <?= number_format($_SESSION["montant"], 0, ',', ' ') ?> FCFA
                        </td>
                    </tr>
                    <tr>
                        <th>Motif</th>
                        <td colspan="3">Frais d'inscription</td>
                    </tr>
                </tbody>
            </table>

            <div class="mt-5 text-end">
                <p>Fait à Kaolack, le <?= date("d/m/Y") ?></p>
                <p><strong>Signature du caissier·e :</strong></p>
                <br><br>
                <p>__________________________</p>
            </div>

            <div class="text-end mt-4">
                <button onclick="window.print()" class="btn btn-outline-primary">🖨️ Imprimer</button>
            </div>

        </div>
    </div>
<?php endif; ?>
