<?php
require('includes/dbconn.php');

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Identifiant invalide.");
}

$id = intval($_GET['id']);

$res = mysqli_query($conn, "SELECT e.*, c.nom AS classe_nom, n.nom AS niveau_nom
    FROM etudiants e
    LEFT JOIN classes c ON e.classe_id = c.id
    LEFT JOIN niveaux n ON e.niveau = n.id
    WHERE e.id = $id LIMIT 1");

if (!$res || mysqli_num_rows($res) === 0) {
    die("Étudiant non trouvé.");
}

$etudiant = mysqli_fetch_assoc($res);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8" />
<title>Reçu d'inscription</title>
<style>
/* Style pour impression */
body { font-family: Arial, sans-serif; margin: 20px; }
h1 { text-align: center; }
table { width: 100%; border-collapse: collapse; margin-top: 20px; }
td, th { padding: 8px; border: 1px solid #ccc; }
</style>
</head>
<body>
<h1>Reçu d'inscription</h1>
<table>
  <tr><th>Matricule</th><td><?= htmlspecialchars($etudiant['matricule']) ?></td></tr>
  <tr><th>Nom et prénom</th><td><?= htmlspecialchars($etudiant['prenom']) . ' ' . htmlspecialchars($etudiant['noms']) ?></td></tr>
  <tr><th>Date de naissance</th><td><?= htmlspecialchars($etudiant['date_de_naissance']) ?></td></tr>
  <tr><th>Lieu de naissance</th><td><?= htmlspecialchars($etudiant['lieu_de_naissance']) ?></td></tr>
  <tr><th>Adresse</th><td><?= htmlspecialchars($etudiant['adresse']) ?></td></tr>
  <tr><th>Téléphone</th><td><?= htmlspecialchars($etudiant['phone']) ?></td></tr>
  <tr><th>Nationalité</th><td><?= htmlspecialchars($etudiant['nationnalite']) ?></td></tr>
  <tr><th>Classe</th><td><?= htmlspecialchars($etudiant['classe_nom']) ?></td></tr>
  <tr><th>Niveau</th><td><?= htmlspecialchars($etudiant['niveau_nom']) ?></td></tr>
  <tr><th>Montant payé</th><td><?= number_format($etudiant['montant'], 0, ',', ' ') ?> F CFA</td></tr>
</table>

<script>
window.onload = function() {
  window.print(); // affiche la boîte d'impression automatiquement
}
</script>
</body>
</html>
