<?php 
session_start();
$userprofil = $_SESSION['user'];
if ($userprofil == true) {
    include('includes/header.php');
    require_once "includes/dbconn.php";
} else {
    header("Location: login.php");
    exit();
}

$success = null;
$redirect_id = null;

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $date_reglement = $_POST['date'];
    $objet = trim($_POST['objet']);
    $nom_complet = trim($_POST['nom_complet']);
    $montant = floatval($_POST['montant']);
    $cn = trim($_POST['cn']);
    $libelle = trim($_POST['libelle']);

    if ($objet && $nom_complet && $montant > 0 && $cn && $libelle && $date_reglement) {
        $stmt = $conn->prepare("INSERT INTO lettres_reglement (date_reglement, objet, nom_complet, montant, cn, libelle) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("ssssds", $date_reglement, $objet, $nom_complet, $montant, $cn, $libelle);

        if ($stmt->execute()) {
            $redirect_id = $stmt->insert_id;
            $success = "Lettre de règlement enregistrée avec succès.";
        } else {
            $error = "Erreur lors de l'enregistrement.";
        }
    } else {
        $error = "Veuillez remplir tous les champs correctement.";
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Lettre de règlement</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        :root {
            --bordeaux: #800020;
            --bordeaux-light: #a0404a;
            --bordeaux-dark: #5c0013;
        }
        body {
            background-color: #f8f9fa;
        }
        .card-header-bordeaux {
            background-color: var(--bordeaux);
            color: white;
        }
        .btn-bordeaux {
            background-color: var(--bordeaux);
            border-color: var(--bordeaux);
            color: white;
        }
        .btn-bordeaux:hover {
            background-color: var(--bordeaux-dark);
            border-color: var(--bordeaux-dark);
        }
        .form-control:focus {
            border-color: var(--bordeaux-light);
            box-shadow: 0 0 0 0.25rem rgba(128, 0, 32, 0.25);
        }
        .label-bordeaux {
            color: var(--bordeaux);
            font-weight: 500;
        }
    </style>
</head>
<body>
<div class="container py-4">
    <div class="card shadow">
        <div class="card-header card-header-bordeaux">
            <h3 class="mb-0"><i class="fas fa-file-invoice-dollar me-2"></i>Lettre de règlement</h3>
        </div>
        <div class="card-body">
            <?php if (isset($error)): ?>
                <div class="alert alert-danger"><?= $error ?></div>
            <?php endif; ?>

            <form method="POST">
                <div class="row mb-3">
                    <div class="col-md-6 mb-3">
                        <label for="date" class="form-label label-bordeaux">Date</label>
                        <input type="date" name="date" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="objet" class="form-label label-bordeaux">Objet</label>
                        <input type="text" name="objet" class="form-control" required>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6 mb-3">
                        <label for="nom_complet" class="form-label label-bordeaux">Nom complet</label>
                        <input type="text" name="nom_complet" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="montant" class="form-label label-bordeaux">Montant</label>
                        <input type="number" name="montant" step="0.01" class="form-control" required>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-6 mb-3">
                        <label for="cn" class="form-label label-bordeaux">Numéro CN</label>
                        <input type="text" name="cn" class="form-control" required>
                    </div>
                    <div class="col-md-6 mb-3">
                        <label for="libelle" class="form-label label-bordeaux">Libellé</label>
                        <textarea name="libelle" class="form-control" rows="3" required></textarea>
                    </div>
                </div>

                <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                    <button type="submit" class="btn btn-bordeaux">
                        <i class="fas fa-save me-1"></i> Enregistrer
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php if (isset($redirect_id)): ?>
<script>
Swal.fire({
    title: 'Enregistré',
    text: 'Lettre de règlement enregistrée avec succès.',
    icon: 'success',
    confirmButtonColor: '#800020',
    confirmButtonText: 'Voir le reçu'
}).then((result) => {
    if (result.isConfirmed) {
        window.location.href = 'recu_reglement.php?id=<?= $redirect_id ?>';
    }
});
</script>
<?php endif; ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>