<?php 
session_start();
$userprofil = $_SESSION['user'] ?? null;
if (!$userprofil) {
    header("Location: login.php");
    exit();
}
include('includes/header.php');
require_once "includes/dbconn.php";

$classes = mysqli_query($conn, "SELECT * FROM classes ORDER BY nom");
$modules = mysqli_query($conn, "SELECT * FROM modules ORDER BY nom");
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Sélection Classe & Module</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container py-4 no-print">
    <form method="GET" action="feuille.php" class="row g-3">
        <div class="col-md-6">
            <label class="form-label">Sélectionner une classe :</label>
            <select name="classe_id" class="form-select" required>
                <option value="">-- Choisir --</option>
                <?php while ($c = mysqli_fetch_assoc($classes)): ?>
                    <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['nom']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-6">
            <label class="form-label">Sélectionner un module :</label>
            <select name="module_id" class="form-select" required>
                <option value="">-- Choisir --</option>
                <?php while ($m = mysqli_fetch_assoc($modules)): ?>
                    <option value="<?= $m['id'] ?>"><?= htmlspecialchars($m['nom']) ?></option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-12 d-grid">
            <button type="submit" class="btn btn-success">Afficher la feuille</button>
        </div>
    </form>
</div>

</body>
</html>
