<?php
session_start();
require_once "includes/dbconn.php";

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';

    if (empty($username) || empty($password)) {
        $error = "Veuillez remplir tous les champs.";
    } else {
        $stmt = $conn->prepare("SELECT id, login, password, role FROM users WHERE login = ?");
        $stmt->bind_param("s", $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($user = $result->fetch_assoc()) {
            if (password_verify($password, $user['password'])) {
                $_SESSION['user'] = [
                    'id' => $user['id'],
                    'login' => $user['login'],
                    'role' => $user['role']
                ];
                header("Location: index.php");
                exit();
            } else {
                $error = "Mot de passe incorrect.";
            }
        } else {
            $error = "Utilisateur non trouvé.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Connexion</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body, html {
            height: 100%;
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
        }

        .login-container {
            display: flex;
            height: 100vh;
        }

        .login-left {
            position: relative;
            flex: 1;
            background: #068526ff;
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }

        .login-left::before {
            content: "";
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: url('assetss/image.jpeg') center/cover no-repeat;
            z-index: 1;
        }

        .login-left::after {
            content: "";
            position: absolute;
            top: 0; left: 0;
            width: 100%; height: 100%;
            background: linear-gradient(to bottom right, rgba(5, 129, 46, 0.8), rgba(0, 0, 0, 0.7));
            z-index: 2;
        }

        .login-left .content {
            position: relative;
            z-index: 3;
            text-align: center;
            padding: 30px;
        }

        .login-left h2 {
            font-weight: bold;
            font-size: 32px;
        }

        .login-left p {
            font-size: 16px;
            opacity: 0.9;
        }

        .login-right {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            background: #ffffff;
            padding: 30px;
        }

        .form-container {
            width: 100%;
            max-width: 400px;
            background: #ffffff;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }

        .btn-bordeaux {
            background-color: #089234ff;
            color: #fff;
        }

        .btn-bordeaux:hover {
            background-color: #05842fff;
        }

        @media (max-width: 768px) {
            .login-container {
                flex-direction: column;
            }

            .login-left, .login-right {
                flex: none;
                width: 100%;
                height: 50vh;
            }

            .login-left::before,
            .login-left::after {
                height: 100%;
            }

            .form-container {
                margin-top: 20px;
            }
        }
    </style>
</head>
<body>

<div class="login-container">
    <!-- Partie gauche -->
    <div class="login-left">
        <div class="content">
            <h2>Bienvenue sur la plateforme</h2>
            <p>Connectez-vous pour accéder à toutes les fonctionnalités : gestion des étudiants, paiements, emplois du temps et plus encore.</p>
        </div>
    </div>

    <!-- Partie droite : formulaire -->
    <div class="login-right">
        <div class="form-container">
            <h4 class="text-center mb-4">Connexion</h4>

            <?php if (!empty($error)): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>

            <form method="POST" action="">
                <div class="mb-3">
                    <label for="username" class="form-label">Nom d'utilisateur</label>
                    <input type="text" name="username" id="username" class="form-control" required>
                </div>

                <div class="mb-3">
                    <label for="password" class="form-label">Mot de passe</label>
                    <input type="password" name="password" id="password" class="form-control" required>
                </div>

                <div class="d-grid">
                    <button type="submit" class="btn btn-bordeaux">Se connecter</button>
                </div>
            </form>

            <div class="text-center text-muted mt-3">
                &copy; <?= date('Y') ?> - Main IT-Center
            </div>
        </div>
    </div>
</div>

</body>
</html>
