<?php
session_start();
require('includes/dbconn.php');  // ta connexion à la BDD

// Récupérer matricule dans l'URL
if (!isset($_GET['matricule'])) {
    die("Matricule non fourni.");
}
$matricule = $_GET['matricule'];

// Récupérer infos étudiant
$sql_etudiant = "
    SELECT e.*, c.nom AS classe_nom, n.nom AS niveau_nom 
    FROM etudiants e
    LEFT JOIN classes c ON e.classe_id = c.id
    LEFT JOIN niveaux n ON e.niveau = n.id
    WHERE e.matricule = ?
";
$stmt = $conn->prepare($sql_etudiant);
$stmt->bind_param("s", $matricule);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    die("Aucun étudiant trouvé avec ce matricule.");
}

$etudiant = $result->fetch_assoc();

// Récupérer les mois déjà payés
$sql_paiements = "SELECT mois, montant, date_paiement FROM paiements WHERE etudiant_id = ? ORDER BY mois DESC";
$stmt2 = $conn->prepare($sql_paiements);
$stmt2->bind_param("i", $etudiant['id']);
$stmt2->execute();
$paiements_result = $stmt2->get_result();
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8" />
    <title>Info Étudiant & Paiements</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body class="bg-light">

<div class="container py-5">
    <h2 class="mb-4">Informations de l'étudiant</h2>
    <div class="card mb-5 shadow-sm">
        <div class="card-body">
            <p><strong>Matricule:</strong> <?= htmlspecialchars($etudiant['matricule']) ?></p>
            <p><strong>Nom & Prénom:</strong> <?= htmlspecialchars($etudiant['noms']) ?> <?= htmlspecialchars($etudiant['prenom']) ?></p>
            <p><strong>Date de naissance:</strong> <?= htmlspecialchars($etudiant['date_de_naissance']) ?></p>
            <p><strong>Classe:</strong> <?= htmlspecialchars($etudiant['classe_nom']) ?></p>
            <p><strong>Niveau:</strong> <?= htmlspecialchars($etudiant['niveau_nom']) ?></p>
            <p><strong>Adresse:</strong> <?= htmlspecialchars($etudiant['adresse']) ?></p>
            <p><strong>Téléphone:</strong> <?= htmlspecialchars($etudiant['phone']) ?></p>
            <!-- Ajoute plus d'infos si besoin -->
        </div>
    </div>

    <h3>Mois déjà payés</h3>
    <?php if ($paiements_result->num_rows > 0): ?>
        <table class="table table-bordered table-striped bg-white shadow-sm">
            <thead>
                <tr>
                    <th>Mois</th>
                    <th>Montant</th>
                    <th>Date de paiement</th>
                </tr>
            </thead>
            <tbody>
                <?php while($paiement = $paiements_result->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($paiement['mois']) ?></td>
                        <td><?= htmlspecialchars(number_format($paiement['montant'], 2, ',', ' ')) ?> €</td>
                        <td><?= htmlspecialchars(date('d/m/Y', strtotime($paiement['date_paiement']))) ?></td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p class="text-muted">Aucun paiement enregistré pour cet étudiant.</p>
    <?php endif; ?>
</div>

</body>
</html>
