<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Emploi du Temps</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f6f9;
    }

    .emploi-container {
      max-width: 1200px;
      margin: auto;
      background: white;
      padding: 30px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }

    h2 {
      text-align: center;
      margin-bottom: 30px;
      font-weight: bold;
    }

    .table th, .table td {
      text-align: center;
      vertical-align: middle;
      border: 1px solid #dee2e6;
    }

    .horaire {
      background-color: #f0f0f0;
      font-weight: bold;
    }

    /* Couleurs par matière (exemples) */
    .maths { background-color: #e8f0fe; }
    .physique { background-color: #fff3cd; }
    .francais { background-color: #fde2e2; }
    .informatique { background-color: #d1f0d1; }
    .anglais { background-color: #dbeafe; }
    .svt { background-color: #fef9c3; }
    .histoire { background-color: #f9dede; }
    .eps { background-color: #e0f7fa; }
    .projet { background-color: #e8eaf6; }
    .atelier { background-color: #fff0f5; }

    @media print {
      body {
        margin: 0;
        background: white;
      }

      .emploi-container {
        box-shadow: none;
        padding: 10px;
        width: 100%;
        page-break-inside: avoid;
      }

      @page {
        size: A4 landscape;
        margin: 10mm;
      }

      .no-print {
        display: none;
      }
    }
  </style>
</head>
<body>

<div class="emploi-container">
  <h2>Emploi du Temps Hebdomadaire</h2>

  <table class="table table-bordered">
    <thead class="table-primary">
      <tr>
        <th>Heure</th>
        <th>Lundi</th>
        <th>Mardi</th>
        <th>Mercredi</th>
        <th>Jeudi</th>
        <th>Vendredi</th>
        <th>Samedi</th>
      </tr>
    </thead>
    <tbody>
      <!-- Matin -->
      <tr>
        <td class="horaire">08h - 10h</td>
        <td class="maths">Maths<br><small>Mr. Dupont</small></td>
        <td class="physique">Physique<br><small>Mme. Leroy</small></td>
        <td class="francais">Français<br><small>M. Martin</small></td>
        <td class="svt">SVT<br><small>Mme. Diarra</small></td>
        <td class="maths">Maths<br><small>Mr. Dupont</small></td>
        <td>-</td>
      </tr>
      <tr>
        <td class="horaire">10h - 12h</td>
        <td class="anglais">Anglais<br><small>Mme. Smith</small></td>
        <td class="histoire">Histoire<br><small>M. Diallo</small></td>
        <td class="informatique">Info<br><small>M. Keita</small></td>
        <td class="francais">Français<br><small>M. Martin</small></td>
        <td class="eps">EPS<br><small>Mme. Koné</small></td>
        <td>-</td>
      </tr>

      <!-- Pause Déjeuner -->
      <tr>
        <td class="horaire">12h - 15h</td>
        <td colspan="6" class="text-center bg-secondary text-white">Pause Déjeuner</td>
      </tr>

      <!-- Après-midi -->
      <tr>
        <td class="horaire">15h - 17h</td>
        <td class="informatique">Info<br><small>M. Keita</small></td>
        <td class="francais">Français<br><small>M. Martin</small></td>
        <td class="anglais">Anglais<br><small>Mme. Smith</small></td>
        <td class="physique">Physique<br><small>Mme. Leroy</small></td>
        <td class="svt">SVT<br><small>Mme. Diarra</small></td>
        <td class="atelier">Atelier<br><small>M. Camara</small></td>
      </tr>
      <tr>
        <td class="horaire">17h - 19h</td>
        <td class="projet">Projet<br><small>M. Keita</small></td>
        <td class="histoire">Histoire<br><small>M. Diallo</small></td>
        <td class="eps">EPS<br><small>Mme. Koné</small></td>
        <td class="maths">Maths<br><small>Mr. Dupont</small></td>
        <td class="anglais">Anglais<br><small>Mme. Smith</small></td>
        <td>-</td>
      </tr>
    </tbody>
  </table>

  <div class="text-center no-print mt-4">
    <button onclick="window.print()" class="btn btn-primary">🖨️ Imprimer</button>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
