<?php
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}

require_once "includes/dbconn.php";

if (!isset($_GET['id'])) {
    header("Location: lettres_reglement.php");
    exit();
}

$id = intval($_GET['id']);
$stmt = $conn->prepare("SELECT * FROM lettres_reglement WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$lettre = $result->fetch_assoc();

if (!$lettre) {
    die("Lettre de règlement introuvable");
}

$montant = $lettre['montant'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Reçu de règlement #<?= $lettre['id'] ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #800020; /* Bordeaux */
            --secondary-color: #d4af37; /* Or */
            --light-color: #f9f5f0; /* Beige clair */
        }
        
        body {
            background-color: #f5f5f5;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .receipt-container {
            max-width: 800px;
            margin: 30px auto;
            background: white;
            border-radius: 8px;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        
        .header-section {
            background: var(--primary-color);
            color: white;
            padding: 25px;
            text-align: center;
            position: relative;
            border-bottom: 3px solid var(--secondary-color);
        }
        
        .school-name {
            font-weight: 700;
            font-size: 1.8rem;
            margin-bottom: 5px;
        }
        
        .receipt-title {
            font-size: 1.5rem;
            margin: 15px 0 5px;
        }
        
        .receipt-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        
        .receipt-table th {
            background-color: var(--primary-color);
            color: white;
            padding: 12px;
            text-align: left;
            font-weight: 500;
        }
        
        .receipt-table td {
            padding: 12px;
            border-bottom: 1px solid #eee;
        }
        
        .receipt-table tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .amount-cell {
            font-weight: bold;
            color: var(--primary-color);
            font-size: 1.1rem;
        }
        
        .signature-section {
            display: flex;
            justify-content: space-between;
            margin-top: 40px;
            padding: 0 20px;
        }
        
        .signature-box {
            width: 45%;
            text-align: center;
        }
        
        .signature-line {
            border-top: 1px solid #666;
            width: 80%;
            margin: 40px auto 10px;
        }
        
        .footer-section {
            background-color: var(--primary-color);
            color: white;
            padding: 15px;
            text-align: center;
            font-size: 0.8rem;
        }
        
        .stamp {
            position: absolute;
            right: 30px;
            top: 100px;
            width: 90px;
            height: 90px;
            border: 3px solid var(--secondary-color);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary-color);
            font-weight: bold;
            background-color: white;
            transform: rotate(15deg);
        }
        
        @media print {
            @page {
                size: A4;
                margin: 0;
            }
            
            body {
                background: white;
                padding: 0;
            }
            
            .receipt-container {
                box-shadow: none;
                border-radius: 0;
                margin: 0;
            }
            
            .no-print {
                display: none !important;
            }
        }
    </style>
</head>
<body>
<div class="receipt-container">
    <div class="header-section">
        <div class="stamp no-print">PAYÉ</div>
        <h1 class="school-name">ECOLE SINE SALOUM SANTE</h1>
        <p>Kaolack, Leona lot 167 | Téléphone: 33 941 00 08</p>
        <h2 class="receipt-title">REÇU DE RÈGLEMENT</h2>
        <p>N° <?= str_pad($lettre['id'], 6, '0', STR_PAD_LEFT) ?></p>
    </div>
    
    <div style="padding: 25px;">
        <table class="receipt-table">
            <tr>
                <th colspan="2">INFORMATIONS</th>
            </tr>
            <tr>
                <td width="30%">Date</td>
                <td><?= date('d/m/Y', strtotime($lettre['date_reglement'])) ?></td>
            </tr>
            <tr>
                <td>Bénéficiaire</td>
                <td><?= htmlspecialchars($lettre['nom_complet']) ?></td>
            </tr>
            <tr>
                <td>Numéro CN</td>
                <td><?= htmlspecialchars($lettre['cn']) ?></td>
            </tr>
            <tr>
                <td>Référence</td>
                <td><?= htmlspecialchars($lettre['reference'] ?? 'N/A') ?></td>
            </tr>
            <tr>
                <th colspan="2">DÉTAILS DU PAIEMENT</th>
            </tr>
            <tr>
                <td>Montant</td>
                <td class="amount-cell"><?= number_format($montant, 2, ',', ' ') ?> <?= htmlspecialchars($lettre['devise'] ?? 'FCFA') ?></td>
            </tr>
            <tr>
                <td>Objet</td>
                <td><?= htmlspecialchars($lettre['objet']) ?></td>
            </tr>
            <tr>
                <td>Libellé</td>
                <td><?= htmlspecialchars($lettre['libelle']) ?></td>
            </tr>
        </table>
        
        <div class="signature-section">
            <div class="signature-box">
                <div class="signature-line"></div>
                <p>Signature du bénéficiaire</p>
            </div>
            
            <div class="signature-box">
                <div class="signature-line"></div>
                <p>Cachet et signature de l'établissement</p>
            </div>
        </div>
    </div>
    
    <div class="footer-section">
        <p>Ce document constitue une preuve de règlement officielle. Conservez-le précieusement.</p>
        <p class="no-print">Document généré le <?= date('d/m/Y à H:i') ?></p>
    </div>
</div>

<div class="no-print text-center mt-4 mb-5">
    <button onclick="window.print()" class="btn btn-primary btn-lg me-3">
        <i class="fas fa-print me-2"></i>Imprimer
    </button>
    <a href="list_lettre.php" class="btn btn-outline-primary btn-lg">
        <i class="fas fa-list me-2"></i>Retour à la liste
    </a>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    window.onafterprint = function() {
        window.location.href = 'list_lettre.php';
    };
</script>
</body>
</html>