<?php
include("includes/dbconn.php");

if (!isset($_GET['id'])) {
    die("ID de réinscription manquant.");
}

$id = intval($_GET['id']);
$query = "
    SELECT r.id, r.date_reinscription, r.montant, 
           e.noms, e.prenom, e.matricule,
           c.nom AS classe, n.nom AS niveau
    FROM paiements_reinscription r
    JOIN etudiants e ON r.etudiant_id = e.id
    JOIN classes c ON r.classe_id = c.id
    JOIN niveaux n ON c.niveau_id = n.id
    WHERE r.id = $id
    LIMIT 1
";
$res = mysqli_query($conn, $query);

if (!$res || mysqli_num_rows($res) === 0) {
    die("Réinscription introuvable.");
}

$data = mysqli_fetch_assoc($res);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Reçu de Réinscription</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .page-container {
            max-width: 800px;
            margin: 0 auto;
        }
        .receipt {
            background: white;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            padding: 30px;
            margin-bottom: 40px;
            position: relative;
            border: 1px solid #e0e0e0;
        }
        .receipt-header {
            border-bottom: 2px solid #e63946;
            padding-bottom: 15px;
            margin-bottom: 20px;
        }
        .school-name {
            font-weight: 700;
            color: #1d3557;
            font-size: 1.5rem;
        }
        .receipt-title {
            background: linear-gradient(to right, #e63946, #a8dadc);
            color: white;
            padding: 8px 15px;
            border-radius: 5px;
            font-weight: 600;
            text-align: center;
            margin: 20px 0;
            text-shadow: 1px 1px 3px rgba(0,0,0,0.2);
        }
        .receipt-item {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px dashed #eee;
        }
        .receipt-item strong {
            color: #1d3557;
        }
        .receipt-footer {
            margin-top: 30px;
            padding-top: 15px;
            border-top: 2px dashed #e63946;
        }
        .copy-label {
            font-style: italic;
            color: #6c757d;
            text-align: right;
            font-size: 0.9rem;
        }
        .logo {
            max-height: 80px;
            filter: drop-shadow(2px 2px 4px rgba(0,0,0,0.1));
        }
        .scissors {
            text-align: center;
            margin: 10px 0;
            position: relative;
            color: #e63946;
        }
        .scissors::before, .scissors::after {
            content: "";
            position: absolute;
            top: 50%;
            width: 45%;
            height: 1px;
            background: repeating-linear-gradient(to right, #e63946 0, #e63946 5px, transparent 5px, transparent 10px);
        }
        .scissors::before {
            left: 0;
        }
        .scissors::after {
            right: 0;
        }
        .print-btn {
            background: linear-gradient(to right, #1d3557, #457b9d);
            border: none;
            border-radius: 30px;
            padding: 10px 25px;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        @media print {
            body {
                background: none;
                padding: 0;
            }
            .print-btn {
                display: none;
            }
            .receipt {
                box-shadow: none;
                border: none;
                padding: 15px;
                margin-bottom: 20px;
            }
            .scissors {
                margin: 5px 0;
            }
        }
    </style>
</head>
<body>
    <div class="page-container">
        <div class="text-end">
            <button class="btn btn-primary print-btn" onclick="window.print()">
                <i class="fas fa-print me-2"></i>Imprimer le reçu
            </button>
        </div>

        <!-- Premier exemplaire -->
        <div class="receipt">
            <div class="receipt-header d-flex justify-content-between align-items-center">
                <div>
                    <div class="school-name">ECOLE SINE SALOUM SANTE</div>
                    <div class="text-muted small">Kaolack, Leona, Lot 167</div>
                    <div class="text-muted small">Tél: 33 941 00 08 | Email: giesinesaloum@gmail.com</div>
                </div>
                <img src="assets/logo.png" alt="Logo" class="logo">
            </div>

            <div class="receipt-title">
                <i class="fas fa-file-invoice-dollar me-2"></i>REÇU DE RÉINSCRIPTION
            </div>

            <div class="receipt-details">
                <div class="receipt-item">
                    <strong>Matricule:</strong>
                    <span><?= htmlspecialchars($data['matricule']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Nom:</strong>
                    <span><?= htmlspecialchars($data['noms']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Prénom:</strong>
                    <span><?= htmlspecialchars($data['prenom']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Niveau:</strong>
                    <span><?= htmlspecialchars($data['niveau']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Classe:</strong>
                    <span><?= htmlspecialchars($data['classe']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Montant payé:</strong>
                    <span class="text-success fw-bold"><?= number_format($data['montant'], 0, ',', ' ') ?> FCFA</span>
                </div>
                <div class="receipt-item">
                    <strong>Date:</strong>
                    <span><?= date('d/m/Y', strtotime($data['date_reinscription'])) ?></span>
                </div>
            </div>

            <div class="receipt-footer">
                <div class="d-flex justify-content-between mt-4">
                    <div>
                        <div class="mb-1">Signature du caissier:</div>
                        <div style="border-top: 1px solid #333; width: 200px;"></div>
                    </div>
                    <div class="text-end">
                        <div class="copy-label">Copie Étudiant</div>
                        <div class="text-muted small mt-2">N°: <?= str_pad($data['id'], 5, '0', STR_PAD_LEFT) ?></div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Indication de coupure -->
        <div class="scissors">
            <i class="fas fa-cut fa-2x"></i>
        </div>

        <!-- Deuxième exemplaire -->
        <div class="receipt">
            <div class="receipt-header d-flex justify-content-between align-items-center">
                <div>
                    <div class="school-name">ECOLE SINE SALOUM SANTE</div>
                    <div class="text-muted small">Kaolack, Leona, Lot 167</div>
                    <div class="text-muted small">Tél: 33 941 00 08 | Email: giesinesaloum@gmail.com</div>
                </div>
                <img src="assets/logo.png" alt="Logo" class="logo">
            </div>

            <div class="receipt-title">
                <i class="fas fa-file-invoice-dollar me-2"></i>REÇU DE RÉINSCRIPTION
            </div>

            <div class="receipt-details">
                <div class="receipt-item">
                    <strong>Matricule:</strong>
                    <span><?= htmlspecialchars($data['matricule']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Nom:</strong>
                    <span><?= htmlspecialchars($data['noms']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Prénom:</strong>
                    <span><?= htmlspecialchars($data['prenom']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Niveau:</strong>
                    <span><?= htmlspecialchars($data['niveau']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Classe:</strong>
                    <span><?= htmlspecialchars($data['classe']) ?></span>
                </div>
                <div class="receipt-item">
                    <strong>Montant payé:</strong>
                    <span class="text-success fw-bold"><?= number_format($data['montant'], 0, ',', ' ') ?> FCFA</span>
                </div>
                <div class="receipt-item">
                    <strong>Date:</strong>
                    <span><?= date('d/m/Y', strtotime($data['date_reinscription'])) ?></span>
                </div>
            </div>

            <div class="receipt-footer">
                <div class="d-flex justify-content-between mt-4">
                    <div>
                        <div class="mb-1">Signature du caissier:</div>
                        <div style="border-top: 1px solid #333; width: 200px;"></div>
                    </div>
                    <div class="text-end">
                        <div class="copy-label">Copie Administration</div>
                        <div class="text-muted small mt-2">N°: <?= str_pad($data['id'], 5, '0', STR_PAD_LEFT) ?></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Après impression, revenir à la page précédente
        window.onafterprint = function() {
            setTimeout(function() {
                window.history.back();
            }, 500);
        };
    </script>
</body>
</html>