<?php
include("includes/dbconn.php");
include("includes/header.php");

$erreur = "";
$success = "";
$etudiant = null;
$classes = [];

// Charger les classes
$result = mysqli_query($conn, "SELECT c.id, c.nom, n.nom_niveau as niveau FROM classes c JOIN niveaux n ON c.niveau_id = n.id");
while ($row = mysqli_fetch_assoc($result)) {
    $classes[] = $row;
}

// Recherche d'étudiant
if (isset($_POST['rechercher'])) {
    $matricule = mysqli_real_escape_string($conn, $_POST['matricule']);
    $query = "
        SELECT e.id, e.noms, e.prenom, e.classe_id, c.nom as classe, n.nom_niveau as niveau
        FROM etudiants e
        JOIN classes c ON e.classe_id = c.id
        JOIN niveaux n ON c.niveau_id = n.id
        WHERE e.matricule = '$matricule'
        LIMIT 1
    ";
    $res = mysqli_query($conn, $query);
    if (mysqli_num_rows($res) == 1) {
        $etudiant = mysqli_fetch_assoc($res);
    } else {
        $erreur = "Aucun étudiant trouvé avec ce matricule.";
    }
}

// Réinscription
if (isset($_POST['reinscrire'])) {
    $etudiant_id = intval($_POST['etudiant_id']);
    $nouvelle_classe = intval($_POST['nouvelle_classe']);

    $update = mysqli_query($conn, "UPDATE etudiants SET classe_id = $nouvelle_classe WHERE id = $etudiant_id");
    if ($update) {
        $success = "Réinscription effectuée avec succès.";
    } else {
        $erreur = "Erreur lors de la réinscription.";
    }
}
?>

<style>
    :root {
        --primary-color: #2c7873;
        --secondary-color: #6fb98f;
        --light-color: #e9f5f4;
        --dark-color: #004445;
    }
    
    .page-header {
        background: linear-gradient(135deg, var(--primary-color), var(--dark-color));
        color: white;
        padding: 1.5rem;
        border-radius: 8px;
        margin-bottom: 2rem;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
    }
    
    .form-card {
        border: none;
        border-radius: 8px;
        box-shadow: 0 2px 15px rgba(0, 0, 0, 0.1);
        margin-bottom: 2rem;
        overflow: hidden;
    }
    
    .form-card .card-header {
        background-color: var(--primary-color);
        color: white;
        padding: 1rem 1.5rem;
        border-bottom: none;
    }
    
    .form-card .card-body {
        padding: 2rem;
    }
    
    .btn-primary {
        background-color: var(--primary-color);
        border-color: var(--primary-color);
    }
    
    .btn-primary:hover {
        background-color: var(--dark-color);
        border-color: var(--dark-color);
    }
    
    .btn-outline-primary {
        color: var(--primary-color);
        border-color: var(--primary-color);
    }
    
    .btn-outline-primary:hover {
        background-color: var(--primary-color);
        color: white;
    }
    
    .form-label {
        color: var(--dark-color);
        font-weight: 500;
    }
    
    .form-control, .form-select {
        border-radius: 4px;
        padding: 0.5rem 0.75rem;
    }
    
    .alert {
        border-radius: 4px;
    }
    
    .student-info {
        background-color: var(--light-color);
        border-radius: 8px;
        padding: 1.5rem;
        margin-bottom: 1.5rem;
    }
</style>

<div class="container py-4">
    <!-- En-tête de page -->
    <div class="page-header">
        <div class="d-flex justify-content-between align-items-center">
            <div>
                <h2><i class="fas fa-user-graduate me-2"></i> Réinscription d'étudiant</h2>
                <p class="mb-0">Gestion des réinscriptions académiques</p>
            </div>
            <div class="text-end">
                <small><?= date('d/m/Y') ?></small>
            </div>
        </div>
    </div>

    <?php if ($erreur): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <?= $erreur ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <?php if ($success): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <?= $success ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <!-- Formulaire de recherche -->
    <div class="form-card">
        <div class="card-header">
            <h5 class="mb-0"><i class="fas fa-search me-2"></i>Rechercher un étudiant</h5>
        </div>
        <div class="card-body">
            <form method="post">
                <div class="row g-3">
                    <div class="col-md-8">
                        <label class="form-label">Matricule de l'étudiant</label>
                        <input type="text" name="matricule" class="form-control" placeholder="Entrez le matricule" required>
                    </div>
                    <div class="col-md-4 d-flex align-items-end">
                        <button type="submit" name="rechercher" class="btn btn-primary w-100">
                            <i class="fas fa-search me-2"></i>Rechercher
                        </button>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Formulaire de réinscription -->
    <?php if ($etudiant): ?>
        <div class="form-card">
            <div class="card-header">
                <h5 class="mb-0"><i class="fas fa-user-edit me-2"></i>Formulaire de réinscription</h5>
            </div>
            <div class="card-body">
                <form method="post">
                    <input type="hidden" name="etudiant_id" value="<?= $etudiant['id'] ?>">
                    
                    <!-- Informations étudiant -->
                    <div class="student-info">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">Nom complet</label>
                                <input type="text" class="form-control" value="<?= $etudiant['noms'] . ' ' . $etudiant['prenom'] ?>" readonly>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label">Classe actuelle</label>
                                <input type="text" class="form-control" value="<?= $etudiant['classe'] . ' (' . $etudiant['niveau'] . ')' ?>" readonly>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Nouvelle classe -->
                    <div class="row g-3">
                        <div class="col-md-8">
                            <label class="form-label">Nouvelle classe</label>
                            <select name="nouvelle_classe" class="form-select" required>
                                <option value="">-- Sélectionner une classe --</option>
                                <?php foreach ($classes as $c): ?>
                                    <option value="<?= $c['id'] ?>"><?= $c['niveau'] . ' - ' . $c['nom'] ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-4 d-flex align-items-end">
                            <button type="submit" name="reinscrire" class="btn btn-primary w-100">
                                <i class="fas fa-check-circle me-2"></i>Valider la réinscription
                            </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    <?php endif; ?>
</div>

<?php include("includes/footer.php"); ?>