<?php 
ob_start();
session_start();
if (!isset($_SESSION['user'])) {
    header("Location: login.php");
    exit();
}

// Vérifier si l'utilisateur est admin
$isAdmin = ($_SESSION['user']['role'] ?? '') === 'admin'; // Adapté pour éviter les erreurs si non défini

require_once "includes/dbconn.php";
include('includes/header.php');

// Fonction pour formater les dates en français
function formatDateFrancais($dateStr) {
    $mois = [
        'January' => 'Janvier', 'February' => 'Février', 'March' => 'Mars',
        'April' => 'Avril', 'May' => 'Mai', 'June' => 'Juin',
        'July' => 'Juillet', 'August' => 'Août', 'September' => 'Septembre',
        'October' => 'Octobre', 'November' => 'Novembre', 'December' => 'Décembre'
    ];
    
    $date = new DateTime($dateStr);
    $moisAnglais = $date->format('F');
    $moisFrancais = $mois[$moisAnglais] ?? $moisAnglais;
    
    return $moisFrancais . ' ' . $date->format('Y');
}

// Marquer une vacation comme payée (protégé par vérification admin)
if (isset($_GET['payer'], $_GET['enseignant_id'], $_GET['mois'])) {
    if (!$isAdmin) {
        $_SESSION['error'] = "Accès refusé : permissions insuffisantes";
        header("Location: vacations.php");
        exit();
    }
    
    $id = intval($_GET['enseignant_id']);
    $mois = $conn->real_escape_string($_GET['mois']);
    if ($conn->query("UPDATE vacations SET est_paye = 1 WHERE enseignant_id = $id AND mois = '$mois'")) {
        $_SESSION['success'] = "Vacation marquée comme payée avec succès";
    } else {
        $_SESSION['error'] = "Erreur lors du paiement : " . $conn->error;
    }
    header("Location: vacations.php?filtre_mois=$mois");
    exit;
}

// Supprimer les vacations (protégé par vérification admin)
if (isset($_GET['supprimer'], $_GET['enseignant_id'], $_GET['mois'])) {
    if (!$isAdmin) {
        $_SESSION['error'] = "Accès refusé : permissions insuffisantes";
        header("Location: vacations.php");
        exit();
    }
    
    $id = intval($_GET['enseignant_id']);
    $mois = $conn->real_escape_string($_GET['mois']);
    if ($conn->query("DELETE FROM vacations WHERE enseignant_id = $id AND mois = '$mois'")) {
        $_SESSION['success'] = "Vacations supprimées avec succès";
    } else {
        $_SESSION['error'] = "Erreur lors de la suppression : " . $conn->error;
    }
    header("Location: vacations.php?filtre_mois=$mois");
    exit;
}

// Ajouter une vacation (protégé par vérification admin)
if (isset($_POST['ajouter_vacation'])) {
    if (!$isAdmin) {
        $_SESSION['error'] = "Accès refusé : permissions insuffisantes";
        header("Location: vacations.php");
        exit();
    }
    
    $enseignant_id = intval($_POST['enseignant_id']);
    $classe_id = intval($_POST['classe_id']);
    $date = $conn->real_escape_string($_POST['date']);
    $heures = floatval($_POST['heures']);
    $taux = floatval($_POST['taux_horaire']);
    $mois = date('Y-m', strtotime($date));
    
    $sql = "INSERT INTO vacations (enseignant_id, classe_id, date_enregistrement, heures, taux_horaire, mois, est_paye)
            VALUES ($enseignant_id, $classe_id, '$date', $heures, $taux, '$mois', 0)";
    
    if ($conn->query($sql)) {
        $_SESSION['success'] = "Vacation ajoutée avec succès";
    } else {
        $_SESSION['error'] = "Erreur lors de l'ajout : " . $conn->error;
    }
    header("Location: vacations.php?filtre_mois=$mois");
    exit;
}

$filtre_mois = $_GET['filtre_mois'] ?? '';
$sql = "SELECT v.enseignant_id, e.nom, e.prenom, v.mois,
               SUM(v.heures) AS total_heures, AVG(v.taux_horaire) AS taux_moyen,
               SUM(v.heures * v.taux_horaire) AS montant_total, MAX(v.est_paye) AS est_paye
        FROM vacations v
        JOIN enseignants e ON v.enseignant_id = e.id";
if (!empty($filtre_mois)) {
    $mois = $conn->real_escape_string($filtre_mois);
    $sql .= " WHERE v.mois = '$mois'";
}
$sql .= " GROUP BY v.enseignant_id, v.mois ORDER BY v.mois DESC, e.nom, e.prenom";

// Exécuter la requête avec gestion des erreurs
$result = $conn->query($sql);
if (!$result) {
    die("Erreur dans la requête SQL: " . $conn->error);
}

// Calcul des montants payés et non payés pour le mois sélectionné
$montant_paye = 0;
$montant_non_paye = 0;
if (!empty($filtre_mois)) {
    $sql_montants = "SELECT 
                     SUM(CASE WHEN est_paye = 1 THEN heures * taux_horaire ELSE 0 END) AS paye,
                     SUM(CASE WHEN est_paye = 0 THEN heures * taux_horaire ELSE 0 END) AS non_paye
                     FROM vacations WHERE mois = '$mois'";
    $result_montants = $conn->query($sql_montants);
    if ($result_montants && $row_montants = $result_montants->fetch_assoc()) {
        $montant_paye = $row_montants['paye'] ?? 0;
        $montant_non_paye = $row_montants['non_paye'] ?? 0;
    }
}

$enseignants = $conn->query("SELECT id, nom, prenom FROM enseignants ORDER BY nom, prenom");
if (!$enseignants) {
    die("Erreur lors de la récupération des enseignants: " . $conn->error);
}

$classes = $conn->query("SELECT id, nom FROM classes ORDER BY nom");
if (!$classes) {
    die("Erreur lors de la récupération des classes: " . $conn->error);
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Vacations - E3S</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-teal: #008080;
            --secondary-teal: #20B2AA;
            --light-teal: #E0F7FA;
            --dark-teal: #006666;
            --light-gray: #f8f9fa;
        }
        
        body {
            background-color: var(--light-gray);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        /* Styles pour les alertes */
        .alert {
            border-radius: 8px;
        }
        
        /* Styles pour le tableau */
        .table-teal thead th {
            background-color: var(--primary-teal);
            color: white;
        }
        
        .table-teal tbody tr:hover {
            background-color: rgba(0, 128, 128, 0.05);
        }
        
        /* Boutons */
        .btn-teal {
            background-color: var(--primary-teal);
            color: white;
            border-color: var(--primary-teal);
        }
        
        .btn-teal:hover {
            background-color: var(--dark-teal);
            border-color: var(--dark-teal);
            color: white;
        }
        
        .btn-outline-teal {
            color: var(--primary-teal);
            border-color: var(--primary-teal);
        }
        
        .btn-outline-teal:hover {
            background-color: var(--primary-teal);
            color: white;
        }
        
        /* Badges */
        .badge-teal {
            background-color: var(--secondary-teal);
            color: white;
        }
        
        /* Card styles */
        .card-teal {
            border: 1px solid var(--secondary-teal);
            border-radius: 8px;
        }
        
        .card-header-teal {
            background-color: var(--primary-teal);
            color: white;
            border-bottom: 2px solid var(--dark-teal);
        }
        
        /* Form styles */
        .form-control:focus, .form-select:focus {
            border-color: var(--secondary-teal);
            box-shadow: 0 0 0 0.25rem rgba(0, 128, 128, 0.25);
        }
        
        /* Action buttons */
        .action-buttons {
            white-space: nowrap;
        }
        
        /* Modal styles */
        .modal-header-teal {
            background-color: var(--primary-teal);
            color: white;
        }
        
        /* Print styles */
        @media print {
            body {
                margin: 0 !important;
                padding: 0 !important;
            }
            .modal-footer, .btn, .d-print-none {
                display: none !important;
            }
            .modal-content {
                border: none !important;
                box-shadow: none !important;
            }
            .bg-teal, .bg-teal > th, .bg-teal > td {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                background-color: var(--primary-teal) !important;
                color: white !important;
            }
        }
        
        /* Vacation letter styles */
        .vacation-letter {
            border: 2px solid var(--primary-teal);
            border-radius: 10px;
            background: white;
            position: relative;
            overflow: hidden;
        }
        
        .vacation-letter-header {
            background: linear-gradient(135deg, var(--primary-teal), var(--secondary-teal));
            color: white;
            padding: 1rem;
            border-bottom: 3px solid var(--dark-teal);
        }
        
        .vacation-letter-title {
            color: var(--primary-teal);
            font-weight: 700;
        }
        
        .vacation-letter-info {
            background-color: var(--light-teal);
            border-radius: 5px;
        }
        
        .vacation-letter-table thead th {
            background-color: var(--primary-teal);
            color: white;
        }
        
        .vacation-letter-signature {
            border-top: 2px dashed var(--primary-teal);
        }
    </style>
</head>
<body>
<div class="container-fluid py-4">
    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show">
            <i class="fas fa-exclamation-circle me-2"></i>
            <?= htmlspecialchars($_SESSION['error']); unset($_SESSION['error']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success alert-dismissible fade show">
            <i class="fas fa-check-circle me-2"></i>
            <?= htmlspecialchars($_SESSION['success']); unset($_SESSION['success']); ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php endif; ?>

    <div class="card card-teal mb-4">
        <div class="card-header card-header-teal">
            <h2 class="mb-0"><i class="fas fa-chalkboard-teacher me-2"></i>Gestion des Vacations</h2>
        </div>
        <div class="card-body">
            <?php if (!empty($filtre_mois)): ?>
            <div class="row mb-4">
                <div class="col-md-8">
                    <div class="alert alert-info">
                        <h5 class="alert-heading">Récapitulatif pour <?= formatDateFrancais($filtre_mois . '-01') ?></h5>
                        <div class="d-flex justify-content-between">
                            <span class="badge bg-success fs-6">Payé: <?= number_format($montant_paye, 0, ',', ' ') ?> FCFA</span>
                            <span class="badge bg-warning text-dark fs-6">Non payé: <?= number_format($montant_non_paye, 0, ',', ' ') ?> FCFA</span>
                            <span class="badge bg-primary fs-6">Total: <?= number_format($montant_paye + $montant_non_paye, 0, ',', ' ') ?> FCFA</span>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>

            <form method="get" class="row mb-4 g-3">
                <div class="col-md-4">
                    <label for="filtre_mois" class="form-label">Filtrer par mois</label>
                    <input type="month" name="filtre_mois" id="filtre_mois" class="form-control" value="<?= htmlspecialchars($filtre_mois) ?>">
                </div>
                <div class="col-md-4">
                    <button type="submit" class="btn btn-teal mt-4">
                        <i class="fas fa-filter me-2"></i>Filtrer
                    </button>
                    <?php if ($isAdmin): ?>
                        <button type="button" class="btn btn-outline-teal mt-4" data-bs-toggle="modal" data-bs-target="#ajouterVacationModal">
                            <i class="fas fa-plus me-2"></i>Ajouter Vacation
                        </button>
                    <?php endif; ?>
                </div>
            </form>

            <?php if ($result->num_rows > 0): ?>
            <div class="table-responsive">
                <table class="table table-teal table-hover table-bordered">
                    <thead>
                        <tr>
                            <th>Enseignant</th>
                            <th>Mois</th>
                            <th>Heures totales</th>
                            <th>Taux horaire</th>
                            <th>Montant total</th>
                            <th>Statut</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php while ($row = $result->fetch_assoc()): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['nom'] . ' ' . $row['prenom']) ?></td>
                                <td><?= formatDateFrancais($row['mois'] . '-01') ?></td>
                                <td><?= $row['total_heures'] ?> h</td>
                                <td><?= number_format($row['taux_moyen'], 0) ?> FCFA</td>
                                <td><strong><?= number_format($row['montant_total'], 0, ',', ' ') ?> FCFA</strong></td>
                                <td>
                                    <?php if ($row['est_paye']): ?>
                                        <span class="badge bg-success">Payé</span>
                                    <?php else: ?>
                                        <span class="badge bg-warning text-dark">Non payé</span>
                                    <?php endif; ?>
                                </td>
                                <td class="action-buttons">
                                    <button class="btn btn-sm btn-outline-teal" data-bs-toggle="modal" data-bs-target="#lettreModal" onclick="showLettre('<?= htmlspecialchars($row['nom'] . ' ' . $row['prenom']) ?>', '<?= $row['mois'] ?>', <?= $row['total_heures'] ?>, <?= $row['taux_moyen'] ?>, <?= $row['montant_total'] ?>)">
                                        <i class="fas fa-print me-1"></i>Imprimer
                                    </button>
                                    <?php if (!$row['est_paye'] && $isAdmin): ?>
                                        <a href="?payer=1&enseignant_id=<?= $row['enseignant_id'] ?>&mois=<?= $row['mois'] ?>" class="btn btn-sm btn-outline-success" onclick="return confirm('Confirmer le paiement ?')">
                                            <i class="fas fa-check me-1"></i>Marquer Payé
                                        </a>
                                        <a href="?supprimer=1&enseignant_id=<?= $row['enseignant_id'] ?>&mois=<?= $row['mois'] ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Supprimer toutes les vacations de ce mois pour cet enseignant ?')">
                                            <i class="fas fa-trash me-1"></i>Supprimer
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
            <?php else: ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle me-2"></i>Aucune vacation trouvée pour le mois sélectionné
                </div>
            <?php endif; ?>
        </div>
    </div>

    <!-- Modal Ajouter Vacation (seulement visible pour admin) -->
    <?php if ($isAdmin): ?>
    <div class="modal fade" id="ajouterVacationModal" tabindex="-1" aria-labelledby="ajouterVacationModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <form method="post" class="modal-content">
                <div class="modal-header modal-header-teal">
                    <h5 class="modal-title" id="ajouterVacationModalLabel"><i class="fas fa-plus-circle me-2"></i>Ajouter une Vacation</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="enseignant_id" class="form-label">Enseignant</label>
                        <select name="enseignant_id" id="enseignant_id" class="form-select" required>
                            <option value="">-- Choisir un enseignant --</option>
                            <?php 
                            $enseignants->data_seek(0);
                            while($ens = $enseignants->fetch_assoc()): ?>
                                <option value="<?= $ens['id'] ?>">
                                    <?= htmlspecialchars($ens['nom'] . ' ' . htmlspecialchars($ens['prenom'])) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="classe_id" class="form-label">Classe</label>
                        <select name="classe_id" id="classe_id" class="form-select" required>
                            <option value="">-- Choisir une classe --</option>
                            <?php 
                            $classes->data_seek(0);
                            while($cls = $classes->fetch_assoc()): ?>
                                <option value="<?= $cls['id'] ?>"><?= htmlspecialchars($cls['nom']) ?></option>
                            <?php endwhile; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="date" class="form-label">Date</label>
                        <input type="date" name="date" id="date" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label for="heures" class="form-label">Heures</label>
                        <input type="number" name="heures" id="heures" class="form-control" step="0.1" min="0" required>
                    </div>
                    <div class="mb-3">
                        <label for="taux_horaire" class="form-label">Taux Horaire (FCFA)</label>
                        <input type="number" name="taux_horaire" id="taux_horaire" class="form-control" min="0" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>Annuler
                    </button>
                    <button type="submit" name="ajouter_vacation" class="btn btn-teal">
                        <i class="fas fa-save me-2"></i>Enregistrer
                    </button>
                </div>
            </form>
        </div>
    </div>
    <?php endif; ?>

    <!-- Modal Lettre de Vacation -->
    <div class="modal fade" id="lettreModal" tabindex="-1" aria-labelledby="lettreModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-xl">
            <div class="modal-content" id="lettreContentToPrint">
                <div class="modal-body p-0">
                    <div class="container-fluid">
                        <div class="row" style="height: 210mm;">
                            <!-- Première attestation (Enseignant) -->
                            <div class="col-md-6" style="border-right: 1px dashed var(--primary-teal); padding: 10px; height: 100%;">
                                <div class="vacation-letter" style="height: 100%;">
                                    <!-- Bande colorée -->
                                    <div style="position: absolute; top: 0; left: 0; width: 100%; height: 5px; background: linear-gradient(90deg, var(--primary-teal), var(--secondary-teal));"></div>
                                    
                                    <!-- En-tête -->
                                    <div class="vacation-letter-header d-flex justify-content-between align-items-center">
                                        <div>
                                            <div style="font-size: 1.1rem; font-weight: 700; margin-bottom: 3px;">
                                              MAIN IT-CENTER
                                            </div>
                                            <div style="font-size: 0.7rem;">
                                                Quartier Leona, Lot 167, Kaolack<br>
                                                Tél: +221 76 947 21 10
                                            </div>
                                        </div>
                                        <img src="assetss/logo.png" alt="Logo" style="max-height: 50px;">
                                    </div>

                                    <!-- Titre -->
                                    <div class="vacation-letter-title text-center my-3">
                                        <i class="fas fa-file-invoice-dollar me-1"></i>ATTESTATION DE VACATION
                                    </div>

                                    <!-- Copie -->
                                    <div class="text-end fw-bold mb-2" style="color: var(--primary-teal); font-size: 0.8rem;">
                                        N°: <span id="lettreNumero1">1</span> | Copie: Enseignant
                                    </div>

                                    <!-- Informations -->
                                    <div class="vacation-letter-info p-3 mb-3">
                                        <h5 style="color: var(--primary-teal); border-bottom: 1px solid #e0e0e0; padding-bottom: 5px; margin-bottom: 8px; font-size: 0.9rem;">
                                            <i class="fas fa-user-tie me-1"></i>Informations
                                        </h5>
                                        <div id="lettreNom1" style="font-size: 1rem; font-weight: 600; margin-bottom: 5px;"></div>
                                        <div id="lettreMois1" style="font-size: 0.85rem;"></div>
                                    </div>

                                    <!-- Détails -->
                                    <table class="vacation-letter-table" style="width: 100%; border-collapse: collapse; margin: 10px 0; font-size: 0.8rem;">
                                        <thead>
                                            <tr>
                                                <th style="padding: 8px 10px; text-align: left;">Détail</th>
                                                <th style="padding: 8px 10px; text-align: left;">Valeur</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr style="border-bottom: 1px solid #e0e0e0;">
                                                <td style="padding: 8px 10px; font-weight: 600; color: var(--primary-teal);">Heures</td>
                                                <td style="padding: 8px 10px;" id="lettreHeures1"></td>
                                            </tr>
                                            <tr style="border-bottom: 1px solid #e0e0e0;">
                                                <td style="padding: 8px 10px; font-weight: 600; color: var(--primary-teal);">Taux horaire</td>
                                                <td style="padding: 8px 10px;" id="lettreTaux1"></td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 8px 10px; font-weight: 600; color: var(--primary-teal);">Montant</td>
                                                <td style="padding: 8px 10px; font-weight: 700; color: var(--secondary-teal);" id="lettreTotal1"></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <!-- Signature -->
                                    <div class="vacation-letter-signature text-center mt-4 pt-3">
                                        <div style="margin-bottom: 5px; font-size: 0.8rem;">Fait à Kaolack, le <?= date('d/m/Y') ?></div>
                                        <div style="margin-bottom: 3px; font-weight: 600;">Le Caissier</div>
                                        <div style="width: 150px; border-top: 1px solid #333; margin: 3px auto;"></div>
                                        <div style="font-style: italic; color: #6c757d; font-size: 0.7rem;">Signature et cachet</div>
                                    </div>
                                </div>
                            </div>

                            <!-- Deuxième attestation (Administration) -->
                            <div class="col-md-6" style="padding: 10px; height: 100%;">
                                <div class="vacation-letter" style="height: 100%;">
                                    <!-- Bande colorée -->
                                    <div style="position: absolute; top: 0; left: 0; width: 100%; height: 5px; background: linear-gradient(90deg, var(--primary-teal), var(--secondary-teal));"></div>
                                    
                                    <!-- En-tête -->
                                    <div class="vacation-letter-header d-flex justify-content-between align-items-center">
                                        <div>
                                            <div style="font-size: 1.1rem; font-weight: 700; margin-bottom: 3px;">
                                               MAIN IT CENTER
                                            </div>
                                            <div style="font-size: 0.7rem;">
                                                Quartier Leona, Lot 167, Kaolack<br>
                                                Tél: +221 76 947 21 10
                                            </div>
                                        </div>
                                        <img src="assetss/logo.jpeg" alt="Logo" style="max-height: 50px;">
                                    </div>

                                    <!-- Titre -->
                                    <div class="vacation-letter-title text-center my-3">
                                        <i class="fas fa-file-invoice-dollar me-1"></i>ATTESTATION DE VACATION
                                    </div>

                                    <!-- Copie -->
                                    <div class="text-end fw-bold mb-2" style="color: var(--primary-teal); font-size: 0.8rem;">
                                        N°: <span id="lettreNumero2">1</span> | Copie: Administration
                                    </div>

                                    <!-- Informations -->
                                    <div class="vacation-letter-info p-3 mb-3">
                                        <h5 style="color: var(--primary-teal); border-bottom: 1px solid #e0e0e0; padding-bottom: 5px; margin-bottom: 8px; font-size: 0.9rem;">
                                            <i class="fas fa-user-tie me-1"></i>Informations
                                        </h5>
                                        <div id="lettreNom2" style="font-size: 1rem; font-weight: 600; margin-bottom: 5px;"></div>
                                        <div id="lettreMois2" style="font-size: 0.85rem;"></div>
                                    </div>

                                    <!-- Détails -->
                                    <table class="vacation-letter-table" style="width: 100%; border-collapse: collapse; margin: 10px 0; font-size: 0.8rem;">
                                        <thead>
                                            <tr>
                                                <th style="padding: 8px 10px; text-align: left;">Détail</th>
                                                <th style="padding: 8px 10px; text-align: left;">Valeur</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr style="border-bottom: 1px solid #e0e0e0;">
                                                <td style="padding: 8px 10px; font-weight: 600; color: var(--primary-teal);">Heures</td>
                                                <td style="padding: 8px 10px;" id="lettreHeures2"></td>
                                            </tr>
                                            <tr style="border-bottom: 1px solid #e0e0e0;">
                                                <td style="padding: 8px 10px; font-weight: 600; color: var(--primary-teal);">Taux horaire</td>
                                                <td style="padding: 8px 10px;" id="lettreTaux2"></td>
                                            </tr>
                                            <tr>
                                                <td style="padding: 8px 10px; font-weight: 600; color: var(--primary-teal);">Montant</td>
                                                <td style="padding: 8px 10px; font-weight: 700; color: var(--secondary-teal);" id="lettreTotal2"></td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <!-- Signature -->
                                    <div class="vacation-letter-signature text-center mt-4 pt-3">
                                        <div style="margin-bottom: 5px; font-size: 0.8rem;">Fait à Kaolack, le <?= date('d/m/Y') ?></div>
                                        <div style="margin-bottom: 3px; font-weight: 600;">Le Caissier</div>
                                        <div style="width: 150px; border-top: 1px solid #333; margin: 3px auto;"></div>
                                        <div style="font-style: italic; color: #6c757d; font-size: 0.7rem;">Signature et cachet</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="modal-footer d-print-none">
                    <button class="btn btn-teal" onclick="printLettre()">
                        <i class="fas fa-print me-2"></i>Imprimer
                    </button>
                    <button class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-2"></i>Fermer
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Variable globale pour suivre le numéro de reçu
    let numeroRecu = 1;

    function showLettre(nom, mois, heures, taux, total) {
        // Convertir le mois en format français
        const moisFr = new Date(mois + '-01').toLocaleDateString('fr-FR', { 
            month: 'long', 
            year: 'numeric' 
        }).replace(/^\w/, c => c.toUpperCase());
        
        // Mettre à jour les informations pour les deux copies
        ['1', '2'].forEach(copy => {
            document.getElementById('lettreNumero' + copy).textContent = numeroRecu;
            document.getElementById('lettreNom' + copy).textContent = nom;
            document.getElementById('lettreMois' + copy).textContent = moisFr;
            document.getElementById('lettreHeures' + copy).textContent = heures + " heures";
            document.getElementById('lettreTaux' + copy).textContent = taux.toLocaleString('fr-FR') + " FCFA";
            document.getElementById('lettreTotal' + copy).textContent = total.toLocaleString('fr-FR') + " FCFA";
        });
        
        // Incrémenter le numéro pour le prochain reçu
        numeroRecu++;
        
        // Afficher le modal
        var lettreModal = new bootstrap.Modal(document.getElementById('lettreModal'));
        lettreModal.show();
    }

    function printLettre() {
        const printContents = document.getElementById('lettreContentToPrint').innerHTML;
        const originalContents = document.body.innerHTML;
        
        document.body.innerHTML = printContents;
        
        // Ajouter des styles spécifiques pour l'impression
        const style = document.createElement('style');
        style.innerHTML = `
            @page {
                size: A4 landscape;
                margin: 0;
            }
            body {
                margin: 0 !important;
                padding: 0 !important;
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                width: 297mm;
                height: 210mm;
            }
            .row {
                display: flex !important;
                width: 100% !important;
                height: 100% !important;
                margin: 0 !important;
            }
            .col-md-6 {
                width: 50% !important;
                float: left !important;
                height: 100% !important;
                page-break-inside: avoid !important;
            }
            .modal-body {
                padding: 0 !important;
            }
            .container-fluid {
                padding: 0 !important;
            }
            .bg-teal, .bg-teal > th, .bg-teal > td {
                -webkit-print-color-adjust: exact !important;
                print-color-adjust: exact !important;
                background-color: var(--primary-teal) !important;
                color: white !important;
            }
        `;
        document.head.appendChild(style);
        
        // Délai pour s'assurer que les styles sont appliqués avant l'impression
        setTimeout(() => {
            window.print();
            document.body.innerHTML = originalContents;
        }, 200);
    }
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
</body>
</html>