<?php
session_start();
$userprofil = $_SESSION['user'] ?? null;
if (!$userprofil) {
    header("Location: login.php");
    exit();
}
include('includes/header.php');
require_once "includes/dbconn.php";

// Requête pour récupérer toutes les autorisations avec infos étudiants et classes
$query = "SELECT a.*, e.noms, e.prenom, c.nom AS classe
          FROM autorisations_absence a
          JOIN etudiants e ON a.etudiant_id = e.id
          JOIN classes c ON a.classe_id = c.id
          ORDER BY a.date_fin DESC";
$result = mysqli_query($conn, $query);
?>

<!-- Styles Bootstrap & DataTables -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css">

<div class="container mt-4">
    <h3 class="mb-4">Liste des autorisations d'absence enregistrées</h3>

    <?php if (mysqli_num_rows($result) == 0): ?>
        <div class="alert alert-info">Aucune autorisation d'absence enregistrée.</div>
    <?php else: ?>
        <div class="table-responsive">
        <table id="table-autorisations" class="table table-sm table-bordered table-striped align-middle small">
            <thead class="table-dark">
                <tr>
                    <th>Nom</th>
                    <th>Prénom</th>
                    <th>Classe</th>
                    <th>Date début</th>
                    <th>Date fin</th>
                    <th>Motif</th>
                    <th>Statut</th>
                </tr>
            </thead>
            <tbody>
                <?php
                $today = new DateTime();
                while ($row = mysqli_fetch_assoc($result)):
                    $dateFin = new DateTime($row['date_fin']);
                    $estObsolete = $dateFin < $today;
                ?>
                <tr>
                    <td><?= htmlspecialchars($row['noms']) ?></td>
                    <td><?= htmlspecialchars($row['prenom']) ?></td>
                    <td><?= htmlspecialchars($row['classe']) ?></td>
                    <td><?= htmlspecialchars($row['date_debut']) ?></td>
                    <td><?= htmlspecialchars($row['date_fin']) ?></td>
                    <td><?= nl2br(htmlspecialchars($row['motif'])) ?></td>
                    <td>
                        <?php if ($estObsolete): ?>
                            <div class="alert alert-danger p-1 m-0 text-center" role="alert" style="font-weight: 600; font-size: 0.8rem;">
                                Autorisation obsolète
                            </div>
                        <?php else: ?>
                            <div class="alert alert-success p-1 m-0 text-center" role="alert" style="font-weight: 600; font-size: 0.8rem;">
                                Autorisation valide
                            </div>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
        </div>
    <?php endif; ?>
</div>

<!-- jQuery et DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<!-- Initialisation DataTables -->
<script>
$(document).ready(function () {
    $('#table-autorisations').DataTable({
        "pageLength": 10,
        "language": {
            "search": "Recherche par nom :",
            "lengthMenu": "Afficher _MENU_ enregistrements",
            "info": "Affichage de _START_ à _END_ sur _TOTAL_",
            "paginate": {
                "first": "Premier",
                "last": "Dernier",
                "next": "Suivant",
                "previous": "Précédent"
            },
            "zeroRecords": "Aucun enregistrement trouvé",
        }
    });
});
</script>
