<?php
session_start();

// Vérification minimale : si aucune donnée de session n'est trouvée, afficher une erreur simple
if (!isset($_SESSION['matricule']) || !isset($_SESSION['nom'])) {
    echo "Aucune donnée de reçu à afficher.";
    exit;
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Reçu d'Inscription</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .page {
            width: 210mm;
            height: 297mm;
            padding: 20mm;
            box-sizing: border-box;
        }

        .recu {
            border: 2px dashed #000;
            padding: 20px;
            margin-bottom: 40px;
        }

        .logo {
            width: 80px;
            height: auto;
        }

        h2, h4 {
            margin: 0;
            text-align: center;
        }

        table {
            width: 100%;
            margin-top: 10px;
            border-collapse: collapse;
        }

        td {
            padding: 8px;
            border: 1px solid #000;
        }

        .infos {
            margin-top: 15px;
            font-size: 15px;
        }

        .signature {
            margin-top: 40px;
            display: flex;
            justify-content: space-between;
        }

        .signature div {
            width: 45%;
            text-align: center;
        }

        hr {
            border: 1px dashed #000;
            margin: 40px 0;
        }

        @media print {
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
<div class="page">

    <!-- Reçu pour l'étudiant -->
    <div class="recu">
        <table>
            <tr>
                <td style="border: none;">
                    <img src="assetss/logo.png" alt="Logo" class="logo">
                </td>
                <td style="text-align: center; border: none;">
                    <h2>Main IT Center</h2>
                    <h4>Reçu d'inscription</h4>
                </td>
                <td style="text-align: right; border: none;">
                    <strong>Copie Étudiant</strong>
                </td>
            </tr>
        </table>

        <div class="infos">
            <p>Nom et prénom : <strong><?= $_SESSION["nom"] ?></strong></p>
            <p>Matricule : <strong><?= $_SESSION["matricule"] ?></strong></p>
            <p>Classe : <strong><?= $_SESSION["classe"] ?></strong></p>
            <p>Montant payé : <strong><?= number_format($_SESSION["montant"], 0, ',', ' ') ?> FCFA</strong></p>
            <p>Date : <strong><?= date("d/m/Y") ?></strong></p>
        </div>

        <div class="signature">
            <div>
                Signature Étudiant
                <br><br><br>____________________
            </div>
            <div>
                Signature Caissier
                <br><br><br>____________________
            </div>
        </div>
    </div>

    <hr>

    <!-- Reçu pour le caissier -->
    <div class="recu">
        <table>
            <tr>
                <td style="border: none;">
                    <img src="logo.png" alt="Logo" class="logo">
                </td>
                <td style="text-align: center; border: none;">
                    <h2>Main IT Center</h2>
                    <h4>Reçu d'inscription</h4>
                </td>
                <td style="text-align: right; border: none;">
                    <strong>Copie Caissier</strong>
                </td>
            </tr>
        </table>

        <div class="infos">
            <p>Nom et prénom : <strong><?= $_SESSION["nom"] ?></strong></p>
            <p>Matricule : <strong><?= $_SESSION["matricule"] ?></strong></p>
            <p>Classe : <strong><?= $_SESSION["classe"] ?></strong></p>
            <p>Montant payé : <strong><?= number_format($_SESSION["montant"], 0, ',', ' ') ?> FCFA</strong></p>
            <p>Date : <strong><?= date("d/m/Y") ?></strong></p>
        </div>

        <div class="signature">
            <div>
                Signature Étudiant
                <br><br><br>____________________
            </div>
            <div>
                Signature Caissier
                <br><br><br>____________________
            </div>
        </div>
    </div>

    <button onclick="window.print()" class="no-print">Imprimer le reçu</button>
</div>
</body>
</html>
